#include "cli.hpp"

#define CMD_LENGTH      15

extern Serial pc;

void cli_sd::welcome(void)
{
    printf("***********************************************\r\n");
    printf("** Welcome to an example application showing **\r\n");
    printf("** basic file operations on sd card.         **\r\n");
    printf("***********************************************\r\n");
}

void cli_sd::print_help(void)
{
    pc.printf("List of commands:\r\n");
    pc.printf("m : mounts a sd_card\r\n");
    pc.printf("p : changes the file to write to\r\n");
    pc.printf("w : write to example file\r\n");
//    pc.printf("a : append to example file\r\n");
    pc.printf("r : read text from example file\r\n");
    pc.printf("h : this help\r\n");
}

char cli_sd::get_cmd(void)
{
    char c;
    while(true)
    {
        c = pc.getc();
        if (c == 'm' || c == 'p' || c == 'w' || c == 'a' || c == 'r' || c == 'h')
        {
            break;
        }
        else
        {
            pc.printf("Unkown command.\r\n");
            this->print_help();
        }
    }
    
    return c;
}
