#include "file_manager.hpp"

extern Serial pc;

void file_manager::print_files(void)
{
    pc.printf("1. %s\r\n", &path_sisk[4]);
    pc.printf("2. %s\r\n", &path_agh[4]);
    pc.printf("3. %s\r\n", &path_krk[4]);
}

void file_manager::get_text(void)
{
   uint8_t char_counter = 0;
   static char byte_received;
   
   do
   {
       byte_received = pc.getc();
       buffer[char_counter] = byte_received;
       char_counter++;
       if (char_counter >= MAX_TEXT_LEN)
       {
           pc.printf("Text too long for buffer.\r\n");
           break;      // Text length reached max length.
       }        
       pc.putc(byte_received);
   }while(byte_received != '\r');
   
   // Add string end sign
   buffer[char_counter] = '\0';
   
   pc.printf("\r\n");
}

void file_manager::get_path(void)
{
    pc.printf("Current file to write to is: %s.\r\n", current_path);    
}

void file_manager::set_path(void)
{
    char number;
    bool correct_number = false;

    if (fp != NULL)
    {
        pc.printf("First close the file!\r\n");
        return;
    }

    this->get_path();
    pc.printf("Write the number of new file to write to. \r\n");    
    this->print_files();

    do
    {
        correct_number = true;
        number = pc.getc();
        switch(number)
        {
            case '1':
                current_path = path_sisk;
                break;
            case '2':
                current_path = path_agh;
                break;
            case '3':
                current_path = path_krk;
                break;
            default:
                pc.printf("Incorrect number, try again.\r\n");
                correct_number = false;
        }
    }while(!correct_number);

    pc.printf("Setting path to: %s.\r\n", current_path);
}

bool file_manager::open_file(char option)
{
    if (fp != NULL)
    {
        pc.printf("File already opened!\r\n");
        return false;
    }

    fp = fopen(this->current_path, &option);

    if (fp != NULL)
    {
        pc.printf("Opened file: %s.\r\n", this->current_path);
    }

    return true;
}

bool file_manager::close_file(void)
{
    if (fp == NULL)
    {
        pc.printf("File already closed!\r\n");
        return false;
    }

    fclose(fp);

    fp = NULL;
    
    
    if (fp != NULL)
    {
        pc.printf("Closed file: %s.\r\n", this->current_path);
    }

    return true;
}

void file_manager::write_to_file(void)
{
    this->open_file('w');

    get_text();
    fprintf(fp, "%s", buffer);
    //fwrite (buffer , sizeof(char), sizeof(buffer), fp); 

    this->close_file();
}


/*void file_manager::append_to_file(void)
{
    //this->open_file('a');
    char * a = "a";
    fp = fopen(this->current_path, a);
    get_text();
    fprintf(fp, "%s", buffer);  
   // fwrite (buffer , sizeof(char), sizeof(buffer), fp);  
    this->close_file();
}*/

void file_manager::read_file(void)
{
    long lSize;
    size_t result;

    this->open_file('r');

    fseek(fp , 0 , SEEK_END);
    lSize = ftell (fp);
    rewind(fp);
    
    // copy the file into the buffer:
    result = fread(buffer, 1, lSize, fp);
    if (result != lSize) 
    {
        pc.printf("Reading error");
    }
    else
    {
        pc.printf("File: %s.\r\r\n", this->current_path);
        pc.printf("%s\r\r\n", buffer);
    }
    

    this->close_file();
}