#ifndef _ACC_CAR_H_
#define _ACC_CAR_H_

#include "mqtt.h"
#include "mbed.h"
#include "Road.h"

class Road;

class AccCar{
public:
    int position;
    int speed;
    int flag;
    bool waited;
    
    // constructor
    AccCar(int id, Road* road, int flag, mqtt* mqtt_singleton);
    
    // sets the car ahead of it
    void set_forward_car(AccCar* car);
    
    // main update function where all the logic is held
    void update();
    
    // reset the car 
    void reset(int speed);
    
    // kill the car essentially
    void stop();
    
    // for breaking continuous right of way ties
    int car_clock;

    int get_car_id();
    
    int wait_time;
    
    int get_cycles();
    
protected:
    int car_id;
    int target_speed;
    AccCar* forward_car;
    Road* road;
    Thread* thread;
    position_msg_t* msg; 
    mqtt* singleton;
    
    int cycles;
        
    // state of the car... are we crossing driving or stopping?
    drive_state_t state;
    // just tells us if we are the lead car or not.
    // if we are lead car we do not have to worry about anything in front
    bool lead;
    
    // update our speed 
    void update_speed();
    
    //
    void drive_normal();
    
    //
    void get_new_target_speed();
    
    //
    void make_position_msg(position_msg_t* msg);

};
#endif
