#ifndef _CAR_H_
#define _CAR_H_

#include "mbed.h"


// The road is 100 meters long
#define ROADLENGTH 100

// Update is running at 1000ms (1 second cycles)
#define TICK 1000

class Car {
public:
    int position; // Position, in meters, of the car
    int speed;    // Speed, in meters, of the car to be used to update the position next Update
    int tick;     // tick to show time passed 5 ticks is an update to speed
    
    // Add any other needed public attributes 
    // ...
    // ...
        
    // Constructor for the Car class
    // Modify as necessary to provide the Car object with
    // access additional resources
    Car(int id);
    
    // Update the position and speed of the car in a 1 second loop
    void update();
    
    // Reset the position of the car to 0 and set the speed to the given speed
    void reset(int speed);
    
    //
    int is_simulating();

  
private:
    int id;         // Identifier so that we can distinguish between cars
    Thread* thread;  // Thread on which to run the car
    int simulation;
    void new_speed(void);
    void update_pos();

    // Add any other needed private attributes
    // ...
    // ... 
};
#endif