#include "Car.h"
#include "signal_wrapper.h"

//
Car::Car(int id) {
    this->id = id;   
    
    // Include any other necessary initialization
    this->tick = 0;
    
    thread = NULL; // Initialize thread to null, since the starting of the simulation is done in reset(-)
}    


// gets new speed sets tick to 0
void Car::new_speed()
{
    int temp_speed = 0;
    // get a valid speed 5-15
    while( temp_speed < 5 )
    {
        temp_speed = rand() %16;
    }
    this->speed = temp_speed;
            
    this->tick = 0;
}

void Car::update_pos()
{
    // update speed every 5 ticks
    if(this->tick == 5)
    {
        new_speed();
    }
        
    // update position based on speed
    this->position += this->speed;
    this->tick++;
}

void Car::update() {
    while (true) {
        // wait for the predefined cycle time
        uint32_t flags = wait_for_signal( CAR_SIGNAL );
    
        // update position of car
        if( flags == CAR_SIGNAL )
        {
            update_pos();
        }
        // unknown signal 
        else
        {
            assert(0);
        }

        
        if(this->position >= ROADLENGTH)
        {
            // notify to end simulation and terminate yourself
            simulation = 0;
            send_signal( CAR_UPDATE_MAIN_SIGNAL );
            thread->terminate();
        }
        
        // signal back saying update compete
        send_signal( CAR_UPDATE_MAIN_SIGNAL );
    }
}


int Car::is_simulating()
{
    return simulation;
}

void Car::reset(int speed) {
    // handle any necessary coordination with main thread
    
    // reset any other attributes that may be necessary
    // ...
    // ...
    
    if (thread != NULL) {   // Clear out the existing thread, if it exists, since we don't know how long it has waited for
        delete thread;
    }
    thread = new Thread();                         // Create a new thread for the car
    thread->start( callback(this, &Car::update) ); // Start the thread with the car's update method
    
    this->simulation = 1;
    this->tick = 0;
    this->position = 0;
    this->speed = speed;
}