#ifndef TRIP_DATA_READER
#define TRIP_DATA_READER

#include "mbed.h"
#include "mtsas.h"

class TripDataReader {
    static const int HARD_BRAKE_THRESHOLD = 10;

public:
    struct TripData {
        int distance;
        int fuel;
        int runtime;

        float averageSpeed;
        float minimumThrottle;
        float averageThrottle;
        float maximumThrottle;
        int hardBrakeCount;
    };
    
public:
    TripDataReader(MTSSerial& obd_, DigitalOut& ledOBD_);

public:
    int init();

    void sample();

    void resetAverageWindow();

    TripData getTripData();

private:
    int readPin(int PID, int dataBytes, uint8_t *data);

private:
    struct TripDataHistory {
        int initialDistance;
        int calls;
        int speed;
        int minT;
        int avgT;
        int maxT;
        int speedSamples;
        int throttleSamples;
        int speedHist[10];
        int speedHistPtr;
        unsigned int brakeEventCount[32];
        int hardBrakeCount;
        bool hardBrakeState;
    };

private:
    MTSSerial& obd;
    DigitalOut& ledOBD;
    TripDataHistory tripDataHistory;
};

#endif
    