#include "mbed.h"
#include "EthernetInterface.h"
#include "GraphicOLED.h"
#include "MARMEX_OB_oled.h"
#include "picojson.h"
#include <string>

#define TEMP_FILE  "/local/thumbtmp.bmp"

// for debug
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// network
EthernetInterface eth;
DigitalIn lnk(P1_25);
DigitalIn spd(P1_26);
DigitalOut speed(p29);
DigitalOut link(p30);

void flip(void const *args) {
    speed = !spd;
    link = !lnk;
}

// display
GraphicOLED oled(p24, p26, p27, p28, p21, p22);
MARMEX_OB_oled oled_s(p5, p7,  p8, p12, p11); // mosi, sclk, cs, rst, power_control

uint8_t c[3];

LocalFileSystem local("local");

const string SERVER_HOST = "XXXXX.herokuapp.com";
const int SERVER_PORT = 80;

const int CATEGORY_NUM = 27;
const string NICO_CATEGORIES[CATEGORY_NUM] = {
  "ent", "music", "sing", "play", "dance",
  "vocaloid", "nicoindies", "animal", "cooking", "nature",
  "travel", "sport", "lecture", "drive", "history",
  "science", "tech", "handcraft", "make", "politics",
  "anime", "game", "toho", "imas", "radio",
  "draw", "diary"
};

string access_recent_api(const string host, const int port, string category)
{
    TCPSocketConnection sock;
    sock.connect(host.c_str(), port);

    char http_cmd[256];
    sprintf(http_cmd, "GET /recent/%s HTTP/1.1\r\nHost: %s\r\nConnection: close\r\n\r\n", category.c_str(), host.c_str());
    pc.printf("Request:\r\n%s\r\n", http_cmd);
    sock.send_all(http_cmd, sizeof(http_cmd)-1);

    char buffer[1024];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\r\n%s\r\n", ret, buffer);
    }

    sock.close();
    return string(buffer);
}

void access_thumb_api(const string host, const int port, string cmsid) {
    TCPSocketConnection sock;
    sock.connect(host.c_str(), port);

    char http_cmd[256];
    sprintf(http_cmd, "GET /thumbnail/%s HTTP/1.1\r\nHost: %s\r\nConnection: close\r\n\r\n", cmsid.c_str(), host.c_str());
    pc.printf("Request:\r\n%s\r\n", http_cmd);
    sock.send_all(http_cmd, sizeof(http_cmd)-1);

    int ret = 0;
    int total_bytes = 0;
    char buffer[1024];
    FILE* pFile;

    pFile = fopen(TEMP_FILE, "w");
    pc.printf("Opening File\n\r");

    bool found_start = false;

    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0) {
            break;
        }
        buffer[ret] = '\0';
        total_bytes += ret;
        //pc.printf("Received %d chars from server, total %d: %s\r\n", ret,total_bytes, buffer);
        if(found_start) {
            fwrite(buffer,1,ret,pFile);
        } else {
            for(int i=1; i<ret; i++) {
                if(buffer[i-1]==0x42 && buffer[i]==0x4D) { //bmp file starts from 424D
                    pc.printf("found start.\n\r");
                    fwrite(&buffer[i-1],1,ret-i+1,pFile);
                    found_start = true;
                    break;
                }
            }
        }
    }

    fclose (pFile);
    pc.printf("Closing File\n\r");
    sock.close();
}

void display_bmp() {
    FILE *f = fopen(TEMP_FILE, "rb");
    fseek(f, 54, 1);
    int color;
    for(int y=127; y >= 0; y--){
        for(int x=0; x < 128; x++){
            for(int i=0;i < 3;i++){
                c[i] = fgetc(f);
            }
            color = c[0] | (c[1] << 8) | (c[2] << 16);
            oled_s.pixel(x, y, color);
        }
    }
    fclose(f);
}

int main()
{
    Thread::wait(2000);
    
    RtosTimer flipper(flip, osTimerPeriodic, NULL);
    flipper.start(50);
    
    oled.cls();
    oled.printf("Hello World!\r\n");
    oled_s.cls();
    oled_s.background(0xFFFFFF);

    eth.init();
    eth.connect();
    oled.cls();
    oled.printf("IP Address: %s\r\n", eth.getIPAddress());

    string response, response_body;

    while(1){
        for(int i=0;i<CATEGORY_NUM;i++){
            response = access_recent_api(SERVER_HOST, SERVER_PORT, NICO_CATEGORIES[i]);
            response_body = response.substr((int)response.find("\r\n\r\n") + 1);
            
            picojson::value v;
            const char *json = response_body.c_str();
            string err = picojson::parse(v, json, json + strlen(json));
            string cmsid = v.get("cmsid").get<string>();
            string category = v.get("category").get<string>();
            string title = v.get("title").get<string>();

            access_thumb_api(SERVER_HOST, SERVER_PORT, cmsid);
            oled.cls();
            oled.printf("%s|%s", category.c_str(), title.c_str());
            display_bmp();
            Thread::wait(5000);
        }
    }

    //eth.disconnect();
}
