#include "mbed.h"

// for debug
DigitalOut leds[]  = {
    DigitalOut( LED1 ),
    DigitalOut( LED2 ),
    DigitalOut( LED3 ),
    DigitalOut( LED4 )
};
Serial pc( USBTX, USBRX );

//TA7774PG
class Stepper {
public:
    Stepper(PinName in_a, PinName in_b, PinName pws) : _in_a(in_a), _in_b(in_b), _pws(pws) {
        _in_a = 0;
        _in_b = 0;
        _pws = 0;
        _next_a = true;
    }
    void next() {
        //_pws = 0;
        //wait(1.0); // for pws
        if( _next_a ) {
            _in_a = !_in_a;
        } else {
            _in_b = !_in_b;
        }
        //_pws = 1;
        _next_a = !_next_a;
    }
private:
    DigitalOut _in_a;
    DigitalOut _in_b;
    DigitalOut _pws;
    bool       _next_a;
};

Ticker ti;
Stepper st( p23, p22, p21 );

// 12hour = 720min to 360 step (mode 1)
const float DAILY_INTERVAL = 120.0;
// 1hour = 60min to 720 step (mode 2)
const float HOURLY_INTERVAL = 10.0;
// for adjust (mode 3)
const float ADJUST_INTERVAL = 1.0;

// switch mode
DigitalIn sw_a(p24, PullUp);
DigitalIn sw_b(p25, PullUp);
int mode = 1;

int main() {
    ti.attach(&st, &Stepper::next, DAILY_INTERVAL);
    wait(2.0);
//    for( int i=0; i < 360; i++ ){
//        leds[0] = !leds[0];
//        st.next();
//        wait(2.0);
//    }
    
    while ( true ) {
        int previous_mode = mode;
        if ( sw_a && sw_b ) {
            mode = 1;
        } else if ( sw_a ) {
            mode = 2;
        } else {
            mode = 3;
        }
        if ( previous_mode != mode ) {
            ti.detach();
            switch ( mode ) {
                case 1:
                    ti.attach(&st, &Stepper::next, DAILY_INTERVAL);
                    break;
                case 2:
                    ti.attach(&st, &Stepper::next, HOURLY_INTERVAL);
                    break;
                case 3:
                    ti.attach(&st, &Stepper::next, ADJUST_INTERVAL);
                    break;
            }
        }
        leds[3] = !leds[3];
        wait(1.0);
    }
}
