#include "mbed.h"
#include "Serial.h"
#include "TinyGPSplus.h"
#include "TextLCD.h"

 
Serial gps(p9, p10);        // tx, rx
Serial pc(USBTX, USBRX);    // tx, rx
DigitalOut myled(LED1);
Serial xbee(p13,p14);
TinyGPSPlus tgps;
AnalogIn vo(p20);
AnalogIn vi(p16);
TextLCD lcd(p24,p26,p27,p28,p29,p30);

bool read_gps(bool debug=false) {
    char ch;
    bool stat;
    if(gps.readable()) {
        ch = gps.getc();
        if(debug)pc.putc(ch);
        stat = tgps.encode(ch);    
    }   
    return stat; 
}

int main()
{
    int hour, time;
    xbee.baud(9600);
    lcd.cls();
    while(1){
        if(read_gps() && tgps.time.second()%5 == 0){
            if(tgps.time.hour()>15){
                hour=tgps.time.hour()%15;
            }else{
                hour=tgps.time.hour()+9;    
            }
            if(time != tgps.time.second()){
                xbee.printf("%d/%d/%d, %d:%d:%d ,",tgps.date.year(),tgps.date.month(),tgps.date.day(),hour,tgps.time.minute(),tgps.time.second());
                xbee.printf("%f, %f ,",tgps.location.lat(),tgps.location.lng());
                xbee.printf("%f\r\n",vo.read()*3.3*0.3);
                lcd.locate(0,0);
                lcd.printf("%f",vo.read()*3.3*0.3);
                time=tgps.time.second();
            }        
        }
    }
 }
 