/*
 *  biquad.h
 *
 *  Original source material from Robert Bristow-Johnson at 
 *  http://www.musicdsp.org/files/Audio-EQ-Cookbook.txt
 *  and Nigel Redmon at http://www.earlevel.com/ 
 *  
 *  Derived from public domain C implementation by Tom St. Denis
 *
 *  Thanks gents!
 *
 *  C++-ification by Mark J. Howell
 *
 */

#ifndef __BIQUAD_H_
#define __BIQUAD_H_

#include <math.h>

#ifndef M_LN2
#define M_LN2       0.69314718055994530942
#endif

#ifndef M_PI
#define M_PI        3.14159265358979323846
#endif

/* formulation types */
typedef enum {
    DIRECT_FORM_I = 0,
    TRANSPOSED_DIRECT_FORM_II
} BIQUAD_FORMULATION_TYPE;

/* filter types */
typedef enum {
    LPF, /* low pass filter */
    HPF, /* High pass filter */
    BPF, /* band pass filter */
    NOTCH, /* Notch Filter */
    PEQ, /* Peaking band EQ filter */
    LSH, /* Low shelf filter */
    HSH /* High shelf filter */
} BIQUAD_FILTER_TYPE;

template <typename T>
class Biquad {

public:
    Biquad(BIQUAD_FILTER_TYPE type, 
        T dbGain,  /* peak gain of filter */
        T freq,  /* center frequency */
        T srate,  /* sampling rate */
        T Q, /* Q */
        BIQUAD_FORMULATION_TYPE form = DIRECT_FORM_I);                       
        
    void Reset(BIQUAD_FILTER_TYPE type, T dbGain, T freq, T srate, T Q, bool clearHistory = false, BIQUAD_FORMULATION_TYPE form = DIRECT_FORM_I);
    
    void CalcCoefficientsDirectI(BIQUAD_FILTER_TYPE type, T dbGain, T freq, T srate, T Q);
    
    void CalcCoefficientsTransposedDirectII(BIQUAD_FILTER_TYPE type, T dbGain, T freq, T srate, T Q);
    
    T Calculate(T sample);
    
    BIQUAD_FORMULATION_TYPE form;    
    
    // used for DIRECT_FORM_1
    T a0_I, a1_I, a2_I, a3_I, a4_I; 
    T x1, x2, y1, y2;
    
    // used for TRANSPOSED_DIRECT_FORM_II
    T a0_II, a1_II, a2_II, b1_II, b2_II;    
    T z1, z2;        

};

#endif

