#include <mbed.h>
#include <Servo.h>
#include <string>
#include <list>
#include <mpr121.h>
#include <SDFileSystem.h>
#include <wave_player.h>

DigitalOut myled(LED1); //use for indication
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

DigitalOut ledSignal(p24);
DigitalOut passReady(p22);
 
Servo myservo(p21);
Serial pc(USBTX, USBRX);  //kinect USB


// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);
// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

//PwmOut speaker(p23); //create a PwmOut object for the speaker
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);


int detect = 0; //detect a human or not
char c;
int key_code_p[4];
int j = 0;
int password[4] = {1, 2, 3, 4};
int passAccept = 0;
 

// Key hit/release interrupt routine
void fallInterrupt() {

  int key_code=0;
  int i=0;
  int value=mpr121.read(0x00);
  value +=mpr121.read(0x01)<<8;
  // LED demo mod
  i=0;
  // puts key number out to LEDs for demo
  for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) {
            key_code=i;
            key_code_p[j] =  key_code;
            j = j+1;
            if(j==4){
                j=0; 
                passReady = 1;     
            }
            else {
                passReady = 0;
            }
        }
  }

            if((password[0]== key_code_p[0]) &&(password[1]== key_code_p[1])&&(password[2]== key_code_p[2])&&(password[3]== key_code_p[3])){
                passAccept = 1;
                ledSignal = 1;
                
            }
            else{
                passAccept = 0;
                ledSignal = 0;      
            }
            
}

int main() { 
    
    passReady = 1;
 
    interrupt.fall(&fallInterrupt); //Touch
    interrupt.mode(PullUp); //Touch

    while(1) {

        float range = 0.0025;
        myservo.calibrate(range, 360.0); 
        myservo = 1;
        
        
        if(pc.readable()){
            detect = pc.getc(); //if 1 someone has been detected
        }
            
        if(detect == 1 && ledSignal==0 ) {
            FILE *wave_file; 
            wave_file=fopen("/sd/mydir/scarface_say_hello.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
            
            myservo = .3;
            wait(30);
            myservo = 1;
        }
    }
}
