/*!
 * @file MuscleWrite.h
 * @brief basic program for muscle controll with mbed/nucleo f446RE 
 * @author m.hdk <m.hdk816@gmail.com>
 * @date 2021
 */

#ifndef MuscleWrite_H
#define MuscleWrite_H

#include "mbed.h"

class MuscleWrite
{
public:
    MuscleWrite(PinName pulse_pin, float period = 0.025, float width = 0.002);
    void enable();
    void disable();
    void write(bool s);

private:
    Timeout tim;
    Ticker tic;
    DigitalOut pulse_pin_;
    float period_;
    float width_;
    bool out;
    int over_cut_width();
    void rise();
    void fall();
};

#endif