/*!
 * @file MuscleWrite.cpp
 * @brief basic program for muscle controll with mbed/nucleo f446RE 
 * @author m.hdk <m.hdk816@gmail.com>
 * @date 2021
 */

#include "mbed.h"
#include "MuscleWrite.h"

MuscleWrite::MuscleWrite(PinName pulse_pin,
                         float period,
                         float width)
    : pulse_pin_(pulse_pin), period_(period), width_(width)
{
    out = false;
    pulse_pin_ = 0;
    period_ = period;
    width_ = width;
}

void MuscleWrite::enable()
{
    over_cut_width();
    tic.attach(this, &MuscleWrite::rise, period_);
}

void MuscleWrite::disable()
{
    tic.detach();
    pulse_pin_ = 0;
    out = false;
}

void MuscleWrite::rise()
{
    if (out)
    {
        pulse_pin_ = 1;
        tim.attach(this, &MuscleWrite::fall, width_);
    }
}

void MuscleWrite::fall()
{
    pulse_pin_ = 0;
}
int MuscleWrite::over_cut_width()
{
    float max = 0.0f;
    max = (period_ / 2.0f);
    if (max < width_)
    {
        width_ = max;
        return 1;
    }
    else
    {
        return 0;
    }
}

void MuscleWrite::write(bool trg)
{
    if (trg)
    {
        out = true;
    }
    else
    {
        out = false;
    }
}