#include "mbed.h"
#include "mavlink/mavlink.h"

//DigitalOut myled(LED_GREEN);
Serial vr(p28, p27);

const int bufSize = 31;

struct StepvrMessage {
    float x;
    float y;
    float z;
    float q1;
    float q2;
    float q3;
    float q4;
};



void syncFrame(void) {
    unsigned char a = 0;
    while (a != 0x5a) {
        if(vr.readable())
            a=vr.getc();
    }

    int readCount = 1;
    while (readCount < bufSize) {
        if(vr.readable()){
            a=vr.getc();
            readCount++;
        }
    }
}




#define BUFFER_LENGTH 2041 // minimum buffer size that can be used with qnx (I don't know why)

uint64_t microsSinceEpoch(){
    return 0;
}



int main()
{
    
    uint8_t mavBuf[BUFFER_LENGTH];

    mavlink_message_t mavMsg;
    uint16_t len;



    vr.baud(921600);
    
    
    
//    while(1){
//      if(vr.readable()){
//            unsigned char w = vr.getc();
//            vr.putc(w);
//        }
//    }
    
    
    syncFrame();
    vr.putc('!');
    
    unsigned char vrBuf[bufSize];
    
    int readCount = 0;
    while(1) {
        if(vr.readable()){
            vrBuf[readCount]=vr.getc();
            readCount++;
        }
        //todo:check sum?
        if (readCount == bufSize){
            if ( (*(unsigned char *)vrBuf) == 0x5a ) {
                StepvrMessage *vrMsg = (StepvrMessage *) (vrBuf + 1);
                
//              /*Send Heartbeat */
//              mavlink_msg_heartbeat_pack(1, 200, &msg, MAV_TYPE_HELICOPTER, MAV_AUTOPILOT_GENERIC, MAV_MODE_GUIDED_ARMED, 0, MAV_STATE_ACTIVE);
//              len = mavlink_msg_to_send_buffer(buf, &msg);
//              pr(buf,len);

                float q[4]={vrMsg->q1,vrMsg->q4,-vrMsg->q2,-vrMsg->q3};
                mavlink_msg_att_pos_mocap_pack(1,200,&mavMsg,microsSinceEpoch(),q,vrMsg->z,-vrMsg->x,-vrMsg->y);
                len = mavlink_msg_to_send_buffer(mavBuf, &mavMsg);
                for(int i=0;i<len;){
                    if(vr.writeable())
                    vr.putc(mavBuf[i++]);  
                }
            }
            else{
                syncFrame();
            }
            readCount = 0;
        }
    }
}
