#include "mbed.h"
#include "MMA8451Q.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

// Open USB Serial Conection
Serial pc(USBTX, USBRX); // tx, rx

int main(void)
{
    pc.baud(115200);
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float data[3];
        
        //x = abs(acc.getAccX());
        //y = abs(acc.getAccY());
        //z = abs(acc.getAccZ());
        acc.getAccAllAxis(data);
        rled = 1.0f - abs(data[0]);
        gled = 1.0f - abs(data[1]);
        bled = 1.0f - abs(data[2]);
        wait(0.1f);
        //pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\t R: %1.2f, G: %1.2f, B: %1.2f\n\r", x, y, z, rled.read(), gled.read(), bled.read());
        pc.printf("%1.2f;%1.2f;%1.2f\n", data[0],data[1],data[2]);

        

    }
}
