/* main.cpp
 * Tested with mbed board: FRDM-KL46Z
 * Author: Mark Gottscho
 * mgottscho@ucla.edu
 */
 
#include "mbed.h"
#include "Timer_LPTMR.h"

DigitalOut green(LED1);

//dummy outputs that sink power through an external resistor to
//amplify active/sleep power differential.
DigitalOut dummy1(PTA6);
DigitalOut dummy2(PTA7);

/**
 * Interrupt service routine called
 * whenever the timer expires. Turns on
 * the board for a while, shines the green LED,
 * and sinks some power that is measurable.
 */
void wakeup_ISR();

void wakeup_ISR() {
    green = 0;
    dummy1 = 1;
    dummy2 = 1;
    
    for (int i = 0; i < 6000000; i++); //spin loop before going back to sleep
    
    green = 1;
    dummy1 = 0;
    dummy2 = 0;
}

/**
 * Test the sleep capability of the mbed. The board
 * will wake up every 0.5 second from a hardware timer
 * interrupt and toggle the green LED.
 */
int main() {
    //Set up timer
    Timer_LPTMR timer;
    timer.enable(&wakeup_ISR);
    timer.start(1000, true, 0); //call wakeup_ISR() every 1000ms
        
    //Init
    green = 1;
    dummy1 = 0;
    dummy2 = 0;
    
    while (1) {
        deepsleep(); //sleep indefinitely. mbed will only wake up when timer expires.
    }
}