// ECE 4180 Final Project
// Fall 2015
// Matthew Ashcraft 4th year EE
// Matthew Golino   5th year CE
//
// Bluetooth Controlled Audio Reactive Infinity Mirror
 
#include "mbed.h"
#include "ble_mini.h"
#include <iostream>
#include "fftstuff.h"

////////////////////////////////////////////////////////////////////////////////
// MBED PIN DESIGNATION
// DO NOT change unless accompanying hardware is altered
////////////////////////////////////////////////////////////////////////////////
// Analog
//AnalogIn mic(p15);      // Analog input for the microphone
//AnalogIn aux(p20);      // Analog input for the DC offset aux cable input
// PWM outputs for RGB LEDs
PwmOut gled(p23);
PwmOut rled(p22);
PwmOut bled(p21);
// Serial Interface for Mbed to PC
Serial pc(USBTX, USBRX);
// Serial Interface for Bluetooth Module to Mbed
Serial device(p9,p10);
// END MBED PIN DESIGNATION

////////////////////////////////////////////////////////////////////////////////
// GLOBAL VARIABLES
// Variables used across multiple functions, simpler than passing to functions
////////////////////////////////////////////////////////////////////////////////

char buf[4];            // Char buffer for bluetooth commands
// Boolean flags for audio sampling
bool AuxIn = false;
bool MicIn = false;
bool inputSelect = false; //false = aux --- true = mic
// Float variable used to write to LED PWM outputs
float redVal = -1;
float greenVal = -1;
float blueVal = -1;
// Float used to "save" previous values for manual writing
float redHold = -1;
float greenHold = -1;
float blueHold = -1;
//strobe values
float strobeVal = -1;
float strobeHold = 0;
// END GLOBAL VARIABLES  


////////////////////////////////////////////////////////////////////////////////
// LED WRITING FUNCTIONS
////////////////////////////////////////////////////////////////////////////////
// Write stored RGB values to PWM outputs
void writeColors(float redVal, float greenVal, float blueVal, float strobeVal)
{
    if (strobeVal > 0) {
        rled = 0;
        gled = 0;
        bled = 0;
        wait(strobeVal);     
    }
    if ((redVal >= 0) || (greenVal >= 0) || (blueVal >= 0)) {
        rled = redVal;
        gled = greenVal;
        bled = blueVal;
    }
}
// END LED WRITING FUNCTIONS

int main() {
    // Initialize frequency window size
    // Set BLE mini baud rate   
    device.baud(57600);
    // Floats used to "hold" RGB values
//    float redHold = -1;
//    float greenHold = -1;
//    float blueHold = -1;
    // Floats used to set and "hold" strobe setting

    while(1) {
        if(device.readable()) {
            // Read in Bluetooth commands
            for(int i = 0; i < 4; i++){
                buf[i]=device.getc();
                pc.printf("%x  ",buf[i]);
            }
            pc.printf("\n\r");
            pc.printf("done\n");
            
            // Check cases for all different switch options based on buf[0];
            char whichInput = buf[0];
            // Check for Bluetooth Connectivity
            if(whichInput == BLE_CONNECTED){        
                pc.printf("case0\n\n");
                //pretty lights for connect
                rled = 255;
                wait(0.25);
                rled=0;
                gled=255;
                wait(0.25);
                gled=0;
                bled=255;
                wait(0.25);
                bled=0;
            }
            else if(whichInput == LIGHTS_OFF_SWITCH){ // Manually turn off lights
                pc.printf("Turning All Lights Off\n\n");
                strobeVal = -1;
                if(buf[1]==0x01){
                    redVal = 0.0f;
                    greenVal = 0.0f;
                    blueVal = 0.0f;
                }
                else if(buf[1]==0x00){
                    redVal = -1.0f;
                    greenVal = -1.0f;
                    blueVal = -1.0f;
                }
            }
            else if(whichInput == IR_SWITCH){       // React to IR remote
                pc.printf("Listening to IR Remote\n\n");
                strobeVal = -1;
                //TBD
                
                
            }
            
            else if(whichInput == MIC_SWITCH){      // React to microphone audio input
                pc.printf("Listening to Microphone for FFT\n\n");
                strobeVal = -1;
                if(buf[1]==0x00){ //switched off
                    redVal = 0;
                    greenVal = 0;
                    blueVal = 0;
                }
                else if (buf[1]==0x01){ //switched on
                    //MicIn = true; //FALSE = MIC CONTROLS -- REMEMBER TO FIX IN CODE
                    inputSelect = true;
                    float colors[3] = {0.0f,0.0f,0.0f};

                    while(!device.readable()){ // done to improve speed => bypass long if statement
                            runFFT(inputSelect, colors); 
                            redVal = colors[0];
                            greenVal = colors[1];
                            blueVal = colors[2];;
                            writeColors(redVal, greenVal, blueVal, strobeVal);
                    }
                }    
                redVal = -1;
                greenVal = -1;
                blueVal = -1;
            }
            else if(whichInput == AUX_SWITCH){      // React to aux cable audio input
                pc.printf("Listening to Aux for FFT\n\n");
                strobeVal = -1;
                if(buf[1]==0x00){ //switched off
                    redVal = 0;
                    greenVal = 0;
                    blueVal = 0;
                }
                else if (buf[1]==0x01){ //switched on
                    inputSelect = false;
                    float colors[3] = {0.0f,0.0f,0.0f};

                    while(!device.readable()){ // done to improve speed => bypass long if statement
                            runFFT(inputSelect, colors); 
                            redVal = colors[0];
                            greenVal = colors[1];
                            blueVal = colors[2];;
                            writeColors(redVal, greenVal, blueVal, strobeVal);
                    }
                }    
                redVal = -1;
                greenVal = -1;
                blueVal = -1;
            }
            else if(whichInput == MANUAL_SWITCH){   // Manual color control
                pc.printf("Colors are Being Controlled Manually\n\n");
                strobeVal = strobeHold;
                if ((redVal < 0) && (redHold < 0)){
                    redVal   = 128.0f/255;
                    greenVal = 128.0f/255;
                    blueVal  = 128.0f/255;
                }
                else{
                    redVal = redHold;
                    greenVal = greenHold;
                    blueVal = blueHold;    
                }
                
                if(buf[1] == 0x00){
                    redVal = -1;
                    greenVal = -1;
                    blueVal = -1;
                }
            }
            else if(whichInput == STROBE_SPEED){ // Strobe feature for manual control
                pc.printf("Strobe Speed Changed\n\n");
                float strobeSpeed = buf[1]; // Value 0-255 to be used in determining strobe speed
                //determine how to control strobe               
                //pc.printf("Strobe rate: %f", strobeSpeed);
                strobeVal = 0.35 - (strobeSpeed*0.35/255);
                if(strobeSpeed == 0){
                    strobeVal=0;
                }
                strobeHold = strobeVal;
            }
            else if(whichInput == COLOR_SELECT){
                pc.printf("case7\n\n");
                // Convert from hex to float
                redVal = buf[1];
                greenVal = buf[2];
                blueVal = buf[3];
                
                // Put in range from 0-1
                redVal=redVal/255;
                greenVal=greenVal/255;
                blueVal=blueVal/255;
                
                // Store for holding purposes
                redHold = redVal;
                greenHold = greenVal;
                blueHold = blueVal;                
            }
            else{
                pc.printf("CASE CONFUSED\n\n");
            }
        } // End readable
    
        else {
            //if we can detect BT or no BT
            //if(//conditions for aux mode)
            //else if (conditions for mic mode)
            //else IR mode
        
        } // End !readable
        
        if(redVal < 0){
            writeColors(0,0,0,strobeVal);    
        }
        else{
            writeColors(redVal, greenVal, blueVal, strobeVal);    
        }    
         
        wait(0.1);
    }// End while(1) loop
}// End main
  