#include "mbed.h"
#include "LM19_Driver.h"
#include "PVD_Driver.h"
#include "SDFileSystem.h"

Serial pc(USBTX, USBRX);
LM19 t_sensor(p19);
PVD photocell(p20);

SDFileSystem sd(p5, p6, p7, p8, "sd");

Timer t;

int main()
{
    t.start();
    mkdir("/sd/mydir",0777);
    char file_name[100];
    sprintf(file_name,"/sd/mydir/%s.txt","test");
    FILE *fp;

    while(1) {
        fp=fopen(file_name,"w");
        if (fp==NULL) {
            error("Could not open file for write \n");
        }
        pc.printf("$TEMP,%.3f,%.3f,%.3f;%\r\n",t.read(),t_sensor.volt(), t_sensor.temp());

        fprintf(fp, "$PVD,%.3f,%.3f,%.3f;%\r\n",t.read(),photocell.Volt(), photocell.Res());
        fclose(fp);
        wait(1);
    }
}

