//Base code for modification for Assignment 3.2
//Blinks LED2 every 200ms using a single Ticker object.
//Created: S. Licht, 10/04/2020
#include "mbed.h"
Ticker tickerLED1;
Ticker tickerLED2;  //create ticker object
Ticker tickerLED3;
DigitalOut LEDOut1(LED1);
DigitalOut LEDOut2(LED2);
DigitalOut LEDOut3(LED3);
InterruptIn butn(p17); //Interupts with pushbutton input p17
Timer debounce;     //define debounce timer

void changeLED2()  //the function that will be called by the ticker object.
{
    LEDOut2 = !LEDOut2;
}

void changeLED3()  //the function that will be called by the ticker object.
{
    LEDOut3 = !LEDOut3;
}

void toggle()
{
    if (debounce.read_ms()>400) { //only allow toggle if debounce timer
        LEDOut1=!LEDOut1;   //has passed 200ms
        debounce.reset();   //restart timer when toggle is performed
    }
}

int main()
{
    debounce.start(); //start
    butn.rise(&toggle);
    tickerLED2.attach(&changeLED2,0.2); //the address of the function to call and the interval in seconds between calls to that function
    tickerLED3.attach(&changeLED3,0.3);
}



