//OCE 360 Final Project
//Annaliese Nardi, Eliza Taylor, Mackenzie Fraser, Megan Gimple
//Updated Code by Stephen Licht
//Description: This code controls the movement of a UAV. Collects pressure, temperaure, light, and acceleration data and writes that to a file on an onboard SD card.

#include "mbed.h"
#include "MMA8452Q.h"  //accelerometer library
#include "MS5837.h"     //pressure sensor library***
#include "SCI_SENSOR.h"     //science sensor library, photocell, temperature cell
#include "SDFileSystem.h"   // SD card library

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Serial pc(USBTX, USBRX);        //initial serial
Serial BLE(p13,p14);            //Bluetooth
MMA8452Q accel(p28,p27,0x1D);   //initial accelerometer
LM19 temp(p19);                 //temperature sensor
PhotoCell light(p20);           //photocell
MS5837 p_sensor(p9, p10, ms5837_addr_no_CS);  //pressure sensor
PwmOut thruster(p21);  //set PWM pin    //max 1.3ms min 1.1ms
PwmOut thruster2(p22); //set PWM pin
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board

//global ticker
Ticker log_ticker;
Ticker accel_ticker;

// global timer
Timer t;
Timer timer2; //part two timer

///File
FILE *fp;
char fname[100];
float PI = 3.14159265358979323846f;

//float operation parameters
float target_depth=0;       //global target depth default 0
int yo_num=0;               //global yo_num default 0
float thrust_on_time=0;     //global thrust_on time default 0
float accelData[3];         //global accel data
//float vessel_length=0.75;   //vessel length 0.75 meters

float part1_iterations=3;
float part2_target_depth=2;
float part2_timeout=60;
float part3_target_depth=2;


//functions
void welcome();
void log_data();

//IMU related
void accel_update(); //update accelerometer related variables. we use imu_ticker to call this function

//Control Parameters
float tim = 5;           //define thruster on time
float percent = 1.5;    //user defined percent of thrust power

//Control related functions
void thrust_on(float pw, float on_time);  //input is pulse width
//void thrust_off(float pw, float on_time); // turn off pulse width


//global variables


//-------------Main functions-----------------------------------------------------------------------------------------
int main()
{
//-----Initialization realted code-------//
    //inital set the thruster esc to 1ms duty cycle
    thruster.period(0.002);      // 2 ms period
    thruster.pulsewidth(1.0/1000.000);
    thruster2.period(0.002);      // 2 ms period
    thruster2.pulsewidth(1.0/1000.000);

    //Initialize accelerometer:
    accel.init();
    led1=1;

    //initialize pressure sensor
    pc.printf("setting the pressure sensor\r\n");
    p_sensor.MS5837Reset();
    p_sensor.MS5837Init();
    pc.printf("setting the tickers\r\n");
    t.start();
    led2=1;
    //*****************************************************
    //waits until it gets an answer over the Bluetooth link!
    welcome();  //prompts user for the logfile name
    //********************************************************


    //-----setup ticker-------//
    //setup ticker to separate log and IMU data update.
    //so we could have all our control code in the while loop
    //   //log at 2 Hz
    accel_ticker.attach(&accel_update,1);  //
    log_ticker.attach(&log_data,0.5);
    led2=0;
    led1=0;

    //Part One
    int count=0;
    while(count<part1_iterations) {
        led1=1;
        count=count+1;
        float pw=percent;
        float on_time=tim;
        thrust_on(pw, on_time); //turn thruster on for 5 seconds
        wait(10);
    }

    //Part Two
    timer2.start();

    while(timer2.read()<part2_timeout) {
        led1=0;
        led2=1;
        float current_depth=p_sensor.depth();
        float pw=percent;
        float on_time=2;

        if (current_depth<part2_target_depth-.2) {
            thrust_on(pw,on_time);
        }
    }
    timer2.reset();
    timer2.start();

    //Part Three
    while(timer2.read()<60) {
        led2=0;
        led3=1;
        float error_deep = part3_target_depth +.3;    //deep end of error band 2.3m ?
        float error_shallow = part3_target_depth -.3; //shallow end of error band 1.7m?
        float current_depth = p_sensor.depth();
        float on_time=2;


        if ((current_depth>=0)&&(current_depth<=error_shallow)) { //if float is between 0 & 1.6 meters deep
            float pw = 1.5;
            thrust_on(pw,on_time);
        }             // turn on thruster at set pw and ontime
        else if ((current_depth>=error_shallow)&&(current_depth<=part3_target_depth)) {//if float is between 1.6 & 2 meters deep
            float pw = 1.2;
            thrust_on(pw,on_time);
        } 
        else if ((current_depth>=part3_target_depth)&&(current_depth<=error_deep)) {//if float is inbetween 2 & 2.4 meters deep
            float pw = 1.0;
            thrust_on(pw,on_time);
        }                        
        else if (current_depth>error_deep) {
            wait(1); //float up 1 second
        }
    }
}



//-------------Customized functions---------------------------------------------//----------------------------------------
///-----------Welcome menu---------------------///
void welcome()
{
    char buffer[100]= {0};
    int flag=1;
    //Flush the port
    while(BLE.readable()) {
        BLE.getc();
    }
    led1=1;
    while(flag) {
        BLE.printf("### I am alive\r\n");
        BLE.printf("### Please enter the log file name you want\r\n");
        if(BLE.readable()) {
            BLE.scanf("%s",buffer);
            sprintf(fname,"/sd/mydir/%s.txt",buffer); //make file name

            flag = 0; //set the flag to 0 to break the while
        }
        wait(1);
    }
    led2=1;
    //print name
    BLE.printf("### name received\r\n");
    BLE.printf("### file name and directory is: \r\n %s\r\n",fname); //file name and location
    //open file test
    mkdir("/sd/mydir",0777); //keep 0777, this is magic #
    fp = fopen(fname, "a");
    if(fp == NULL) {
        BLE.printf("Could not open file for write\n");
    } else {
        BLE.printf("##file open good \n"); //open file and tell if open
        fprintf(fp, "Hello\r\n");
        fclose(fp);
    }

    BLE.printf("### The main program will start in 5 seconds\r\n");
    wait(5);
}

///-----------log functions---------------------///
void log_data()
{

    p_sensor.Barometer_MS5837();

    //Code from Licht
    //Sample code shows how to read temperature and light data:
    BLE.printf("Temperature: %f   Light: %f\r\n",temp.temp(), light.light());

    //Sample code shows how to read pressure sensor
    BLE.printf("Depth: %f Pressure: %f \r\n", p_sensor.depth(), p_sensor.MS5837_Pressure()); //p_sensor.MS5837_Temperature());
    //p_sensor.Barometer_MS5837(); //NOTE: this function prompts the pressure sensor to collect the next data point, so it must be included!

    //Sample code indicates how to read accelerometer data:
    BLE.printf("Acceleration: %f %f %f\r\n",accelData[0],accelData[1],accelData[2]);
    //end of code from Licht
    float ttime =t.read();
    float depth =p_sensor.depth();
    float pressure =p_sensor.MS5837_Pressure();


    fp = fopen(fname, "a");
    fprintf(fp, "$DATA, %f,%f,%f,%f,%f,%f,%f \r\n", ttime,depth,pressure,accelData[0],accelData[1],accelData[2],light.light());
    fclose(fp);
}

///-----------acceleromter related functions---------------------///
void accel_update()
{
    accelData[0] = accel.readX();
    accelData[1] = accel.readY();
    accelData[2] = accel.readZ();
}

///-----------Control related functions---------------------///
////Thruster on control, pw->pulse width in milli-second//
////                        pw range between 1 to 1.5//
////                       on_time-> thruster on time.
void thrust_on(float pw, float on_time)   //input is pulse width
{

    float pw_max=2.0;
    if(pw>pw_max) {
        pw=pw_max; //hard limitation
    }
    Timer tt;
    tt.reset();
    tt.start();
    // lets set the pulse width
    //thruster.period(20.0/1000.00);      // 20 ms period
    thruster.pulsewidth(pw/1000.00);
    thruster2.pulsewidth(pw/1000.00);
    //PWM will be kept until time out
    while(tt.read()<=on_time) {

        BLE.printf("thruster on?...mack is cool\r\n"); //print check
    }
    //stop the timer
    tt.stop();
    //turn off the thruster
    thruster.pulsewidth(1.0/1000.00);
    thruster2.pulsewidth(1.0/1000.00);

}
