#include "HIDScope.h"

HIDScope::HIDScope(int channels) : hid(64,64) 
{
    bufferData      = new float[channels]();
    channelCount    = channels;
    scopeData.length = 64;
}

void HIDScope::set(int ch, float val)
{
    bufferData[ch] = val;
}

void HIDScope::set(int ch, int val)
{
    set(ch,(float)val);
}

void HIDScope::set(int ch, bool val)
{
    set(ch,(val ? 1.0f : 0.0f));
}

void HIDScope::set(int ch, double val)
{
    set(ch,(float)val);
}

void HIDScope::send()
{    
    for(int ch=0; ch<channelCount; ch++)
        memcpy(&scopeData.data[ch*4], &bufferData[ch], 4); // Copy a 4 byte float to the char array
    
    // Send non blocking, can be adjusted to blocking (hid.send)
    hid.sendNB(&scopeData);
}