#include "mbed.h"

//*************Prueba de configuración de entradas salidas analogicas*************/////////////
//Defino salida para comunicar con el PC
Serial pc(USBTX, USBRX);


//Ver esquema de patas
//Defino entradas analógicas
AnalogIn ain(PTB3);
AnalogIn ain2(PTB2);
//Defino la salida analógica
AnalogOut aout(PTE30);
//Y el LED
DigitalOut led(LED1);   //Blue
DigitalOut led2(LED2); //Green

//Variables para comunicación
char buffer_for_incoming_message[6]="";     // creates buffer for message. Length max.:6 ASCII chars
char S_command;

float Input1, Input2;

int timeMs=500;

int main() {
    //Configuro el baudrate y mando un mensaje
     pc.baud(9600);
     pc.printf("20130528 PruebaInOut \r");


    while (1){
        //Va variando el valor de la salida analógica
        aout = aout + 0.2;
        wait_ms(timeMs);
        if(aout == 1) { aout = 0; }
                //aout y ain están conectadas por un cable
        //Cuando el valor de ain supera 0,5 enciende el LED
        if(ain > 0.5) { led = 1;} 
        else { led = 0; }
        
        //Rutina para escribir datos
        if (pc.readable()){                                 // If pc is readable
            led2 = 1;
            pc.scanf("%6s", buffer_for_incoming_message);      
            sscanf( buffer_for_incoming_message, "%c", &S_command );
            
            switch (S_command) {
                case 'C' :
                    //TaraPress = 1;
                    pc.printf("%c \r", S_command);
                    break; 
                case 'M' :
                    Input1=ain;
                    pc.printf("AI1 = %5.3f\r", Input1); 
                    break;
                case 'R' :
                    Input2=ain2;
                    pc.printf("AI2 = %5.3f\r", Input2); 
                    break;
            }
           
        }
            //Manda el valor cada timeMs milisegundos
            /*wait_ms(timeMs);
            Input2=ain2;
            pc.printf("%5.3f\r", Input2); */
    }        

}