#include "mbed.h"
#include <stdio.h>

PwmOut servo0(p21);//θ0 pin
PwmOut servo1(p22);//θ1 pin
PwmOut servo2(p23);//θ2 pin
PwmOut servo3(p24);//θ3 pin
PwmOut servo4(p25);//θ4 pin
PwmOut servo5(p26);//θ5 pin

Serial pc(USBTX, USBRX);
#define SampleFreq   60   // [Hz]
//Ticker          ticker;
FILE* fp;

int cnt;

LocalFileSystem local("local");

float aOut, bOut, cOut, dOut, eOut, fOut;//J123456 degree
int pw0, pw1, pw2, pw3, pw4, pw5;//Output Pulse Width
float* pOut[6];

//degree to PulseWidth
int cal_input0(float arg) {
    return 1475 + int(10.48 * arg);
}
int cal_input1(float arg) {
    return 1218 + int(10.2467 * arg);
}
int cal_input2(float arg) {
    return 1306 + 10.59 * arg;
}
int cal_input3(float arg) {
    return 1224 + int(8.556 * arg);
}
int cal_input4(float arg) {
    return 1460 + int(10.556 * arg);
}
int cal_input5(float arg) {
    return 1922 + int(10.556 * arg);
}
//calcurate PulseWidth
void cal_pw()
{
    pw0 = cal_input0(aOut);
    pw1 = cal_input1(bOut);
    pw2 = cal_input2(cOut);
    pw3 = cal_input3(dOut);
    pw4 = cal_input4(eOut);
    pw5 = cal_input5(fOut);
}
//send PulsWidth to servo
void send_servo()
{
    servo0.pulsewidth_us(pw0);
    servo1.pulsewidth_us(pw1);
    servo2.pulsewidth_us(pw2);
    servo3.pulsewidth_us(pw3);
    servo4.pulsewidth_us(pw4);
    servo5.pulsewidth_us(pw5);
}

//move function set for attach
void move()
{
    cal_pw();
    send_servo();
}
int main(void)
{
    //===============ボーレート=============
    pc.baud(921600);
    pc.format(8, Serial::None, 1);

    char rbuf[4];
    
    //========Control Frequency===========
    float w = 60.0;
    float PWMperiod = 1.0 / w;  
    
    servo0.period(PWMperiod);
    servo1.period(PWMperiod);
    servo2.period(PWMperiod);
    servo3.period(PWMperiod);
    servo4.period(PWMperiod);
    servo5.period(PWMperiod);
        
    // store pointer
    pOut[0] = &aOut;
    pOut[1] = &bOut;
    pOut[2] = &cOut;
    pOut[3] = &dOut;
    pOut[4] = &eOut;
    pOut[5] = &fOut;
    
    while (1) {
        //動かす関数        
        move();
        
        if (pc.readable()) {
            if (pc.getc() != '*') continue;
            if (pc.getc() != '+') continue;
            for (int i = 0; i < 6; i++) {
                for (int b = 0; b < 4; b++)
                    rbuf[b] = pc.getc();

                // ( 4 bytes -> one float )
                float const* f = reinterpret_cast<float const*>(rbuf);
                *pOut[i] = *f;
            }
        }

    }
}