//
// M-Series Random Sequence Generator
//
// Masahiro Furukawa, m.furukawa@ist.osaka-u.ac.jp
// Feb 2, 2021

// m-sequence
// https://okasho-engineer.com/m-sequence/
//
// Maximum-Length Tap Position and Number of taps
// http://wista.jp/M-Seq.htm
//
// 既約多項式
// https://www.nagoya-bunri.ac.jp//~t-ymzm/rand/rand_mseq4.html

#ifndef __M_SERIES_H__
#define __M_SERIES_H__

#define   MSeries_N   16

// m-series definition
class Mseries
{
private:
    uint8_t M[MSeries_N];
    uint8_t H[MSeries_N];

public:
    Mseries()
    {
        init();
    }

    void init(void)
    {
        // the following initial values are not validated
        M[0] = 0;
        M[1] = 0;
        M[2] = 0;
        M[3] = 1;
        M[4] = 0;
        M[5] = 0;
        M[6] = 0;
        M[7] = 1;
        M[8] = 0;
        M[9] = 0;
        M[10] = 0;
        M[11] = 1;
        M[12] = 0;
        M[13] = 0;
        M[14] = 0;
        M[15] = 1;

        // Maximum-Length Tap Position and Number of taps
        // http://www5b.biglobe.ne.jp/~pisan/radio-Msequence.htm
        //
        H[0] = 1;
        H[1] = 0;
        H[2] = 1;
        H[3] = 0;

        H[4] = 0;
        H[5] = 0;
        H[6] = 0;
        H[7] = 0;

        H[8]  = 0;
        H[9]  = 0;
        H[10] = 0;
        H[11] = 1;

        H[12] = 0;
        H[13] = 0;
        H[14] = 0;
        H[15] = 1;

    }

    uint8_t update(void)
    {
        // update M-series
        uint8_t Mtmp = M[0] * H[0];

        // one left-shifting on ring buffer
        M[0] = M[1];

        // take sequential XOR on the entire sequence
        for (int i = 1 ; i < MSeries_N - 1 ; i++) {
            // XOR
            Mtmp = (Mtmp + M[i] * H[i]) % 2;

            // one left-shifting on ring buffer
            M[i] = M[i + 1];
        }

        // store the latest value at the last
        M[MSeries_N - 1] = Mtmp;

        return get();
    }

    uint8_t get(void)
    {
        return M[15];
    }
};


#endif // __M_SERIES_H__