// 
// M-Series Random Sequence Generator
//
// Masahiro Furukawa, m.furukawa@ist.osaka-u.ac.jp
// Feb 2, 2021

#ifndef __KST_SERVO_H__
#define __KST_SERVO_H__

/*
  Kst X08 V5.0
  1.working電圧: DC3.8-8.4V
  2.installationサイズ: 23.5*8*16.8ミリメートル
  3.workingトルク: 2.8キロ。cm-8.4V; 2.2キロ。cm-6.0V; 1.4キロ。cm-3.8V
  4。を最大速度: 0.18秒/60 degree-4.2V; 0.15秒/60 degree-6.0V 0.09秒/60 degree-8.4V
  5.weight: 8グラム
  6.working周波数: 1520us/333hz、900us-2100us
  7.motorタイプ: 7.0ミリメートル中空カップモーター、ダブルベアリング。
  Kst X08H V5.0
  動作電圧: DS3.8V-8.4V
  サイズ: 23.5*8*16.6ミリメートル
  トルク:
  2.8kg.cm 8.4 12v
  2.2kg.cm 6.0 12v
  1.4kg.cm 3.8 12v
  速度:
  0。09sec/60度8.4v
  0。秒/60度6.0v
  0。18sec/60度4.2v
  重量: 8グラム
  動作周波数: 1520us/333hz、900us-2100us
  モーター: 7ミリメートルコアレスモーター
  ボールベアリング: 2BB
  パッケージ付属:
  1 kst X08
  1 kst X08H
*/


#define KST_SERVO_DEG_MAX 120 // deg
#define KST_SERVO_DEG_90   90 // deg
#define KST_SERVO_DEG_MID  60 // deg
#define KST_SERVO_DEG_MIN   0 // deg

#define KST_SERVO_USEC_MAX 2100 //  60deg
#define KST_SERVO_USEC_90  1800 //  60deg
#define KST_SERVO_USEC_MID 1750 //   0deg
#define KST_SERVO_USEC_MIN  900 // -60deg

#define KONDO_SERVO_KRS2572HV_USEC_MAX 3000 //  60deg
#define KONDO_SERVO_KRS2572HV_USEC_180 2800 // 180deg
#define KONDO_SERVO_KRS2572HV_USEC_90  1950 //  90deg
#define ONDOT_SERVO_KRS2572HV_USEC_MIN 1100 //   0deg


#endif //  __KST_SERVO_H__