#include "mbed.h"

#define SampleFreq  1000 // [Hz]

// define serial objects
Serial          pc(USBTX, USBRX);

DigitalOut myled(LED1);

Ticker          ticker;
Timer           timer;

unsigned int usCycle = 1000000/SampleFreq ;
uint8_t dummy_code[6] = {0x01, 0x02, 0xF3, 0xF4, 0x85, 0x86} ;
uint8_t u8buf[6];
uint16_t u16val[3];

void eventFunc(void)
{//
//    timer.reset();
//    timer.start();
    
    // limitation on sending bytes at 921600bps - 92bits(under 100us/sample)
    // requirement : 1kHz sampling
    // = 921.5 bits/sample
    // = 115.1 bytes/sample
    // = 12.7 bytes/axis(9dof, including delimeter) each data uses float type value, equals to 4 bytes as binary description
        
    //fwrite(u8buf, sizeof(uint8_t), 6, stdout);
    
    u16val[2]++;
    
    for ( int i = 0; i < 3; i++ ){
      dummy_code[i*2  ] = 0xFF & ( u16val[i] >> 8 );  // High Byte
      dummy_code[i*2+1] = 0xFF & ( u16val[i] );       // Low Byte  
    }
    for(int i=0;i<6;i++)
        putc(dummy_code[i], stdout);
        
    // terminator for ascii sending only // 
    printf("\r\n");
}

int main()
{   
    pc.baud(921600); //921600 / 115200
    char c;
 
 
    u16val[0] = 12345; // 0x3039
    u16val[1] = 54321; // 0xD431
    u16val[2] = 0; // 0x3279
    
    while(1) {
        if(pc.readable()){
            c = pc.getc();
        
            if(c == 's') {
                // define callback event
                 ticker.attach_us(eventFunc, 1000000.0f/SampleFreq);
            }    
            else if(c == 'r') {
                ticker.detach();
                printf("------\r\n");
            }    
        }
    }
     

}
