#include "mbed.h"

#ifndef SPEAKER
#define SPEAKER
// new class to play a note on Speaker based on PwmOut class
// based on zchen311 implementation
// http://mbed.org/users/zchen311/code/Speaker/
class Speaker
{
public:
    Speaker(PinName pin) : _pin(pin) {
    _volume=0.2;
    }
    // class method to play a note based on PwmOut class
    void changeFrequency(double newNote) {
            _pin.period(1.0/newNote);
            _pin = _volume/2.0;
    }
    
    void stop(){
        _pin=1;
        _pin.period(0);
    }
    
    float* getVolumeBuffer(){
        return &_volume;
    }
private:
    PwmOut _pin;
    float _volume;
};

#endif