#include "Speaker.h"
#include "Note.cpp"
#include "Button.cpp"

class ButtonMusical: public Button
{
public:
    
    ButtonMusical(PinName pin, Note note, Speaker* speaker) : Button(pin),  _note(note), sp(speaker)  {
        alreadyPressed=false;
    }
    void press() {
        if(!alreadyPressed) {
            sp->changeFrequency(_note.getFrequency());
            buttonsPressed++;
            alreadyPressed=true;
        }
    }

    void release() {
        if(alreadyPressed)   {
            if(--buttonsPressed==0)
                sp->stop();
            alreadyPressed=false;
        }
    }

private:
    Note _note;
    bool alreadyPressed;
    Speaker* sp;
    
    int static buttonsPressed;
};