#include "ButtonMusical.cpp"
#include "ButtonDiesis.cpp"
//#include "MyLCD.cpp"

#include "TextLCD.h"
#include "MMA8451Q.h"
#include "TSISensor.h"

#define OCTAVE 0
#define VOLUME 1
#define METRONOME 2
#define TILT_TOLERANCE_SET 0.75
#define TILT_TOLERANCE_RESET 0.05
#define MIN_METRONOME_BPM 30
#define MAX_METRONOME_BPM 185
#define INTERVAL_METRONOME_BPM 5
#define MIN_OCTAVE 2
#define MAX_OCTAVE 6
#define MMA8451_I2C_ADDRESS (0x1d<<1)

TextLCD lcd(PTE5, PTE3, PTE2, PTB11, PTB10, PTB9, TextLCD::LCD16x2); //TextLCD (PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7, LCDType type=LCD16x2, PinName bl=NC, PinName e2=NC, LCDCtrl ctrl=HD44780)
//MyLCD lcd(10, PTE5, PTE3, PTE2, PTB11, PTB10, PTB9);
Speaker speaker (PTA4);
DigitalOut led1(LED1);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
TSISensor slider;
Ticker tLedOn, tLedOff;
int freq;
int multiplier =0;
int bpm = 60;
bool allowEdit=false;
int mode=OCTAVE;


void menuManager()
{
    double y=acc.getAccY();
    if (allowEdit==false) {
        if (y<-TILT_TOLERANCE_SET) {
            allowEdit=true;
            mode=mode+1;
        } else if (y>TILT_TOLERANCE_SET) {
            allowEdit=true;
            mode=mode-1;
        }
    } else {
        if (abs(y)<TILT_TOLERANCE_RESET) {
            allowEdit=false;
        }
    }
    return;
}

void ledOff()
{
    led1=1;
    tLedOff.detach();
}

void ledOn()
{
    led1=0;
    tLedOff.attach(&ledOff, 0.1);
}

void metronomeSettings(int* bpmReg)
{
    float t_bpm = *bpmReg;
    lcd.printf("BPM: %d\n<volume  ottave>", bpm );
    wait(0.1);
    float tmp = slider.readPercentage();
    if(tmp>0) {
        tLedOn.detach();
        while (tmp>0) {
            t_bpm =int((MIN_METRONOME_BPM+tmp*(MAX_METRONOME_BPM-MIN_METRONOME_BPM))/INTERVAL_METRONOME_BPM);
            tmp = slider.readPercentage();
            lcd.cls();
            lcd.printf("BPM: %.0f\n<volume  ottave>",t_bpm*INTERVAL_METRONOME_BPM);
            wait(0.1);
        }
        *bpmReg=(int(t_bpm))*INTERVAL_METRONOME_BPM;
        tLedOn.attach(&ledOn, 60.0/(*bpmReg));
    }
}


void volumeSettings(float* volume)
{
    lcd.printf("VOLUME: %.0f\n%s", (*volume)*10,"<ottave     bpm>");
    wait(0.1);
    float tmp= slider.readPercentage();
    if (tmp>0) {
        *volume = tmp;
        lcd.cls();
        lcd.printf("VOLUME: %.0f\n%s", (*volume)*10,"<ottave     bpm>");
        wait(0.1);
    }
}

void octaveSettings()
{
    
    lcd.printf("OTTAVA %d  \n         volume>",multiplier+4);
    wait(0.1);
    float octave=4;
    float tmp = slider.readPercentage();
    if(tmp>0) {
        while (tmp>0) {
            octave = MIN_OCTAVE+tmp*(MAX_OCTAVE-MIN_OCTAVE);
            multiplier=((int)octave)-4;
            tmp = slider.readPercentage();
            lcd.cls();
            lcd.printf("OTTAVA %.0f  \n         volume>",octave);
            wait(0.1);
        }
    }
}


int ButtonMusical::buttonsPressed = 0;
int main()
{
    led1=1;
    tLedOn.attach(&ledOn, 1.0);
    float* volume=speaker.getVolumeBuffer();

    ButtonDiesis di (PTA13);
    Note DO4(262, true, &multiplier, di.getDiesisPointer());
    Note RE4(294, true, &multiplier, di.getDiesisPointer());
    Note MI4(330, false, &multiplier, di.getDiesisPointer());
    Note FA4(349, true, &multiplier, di.getDiesisPointer());
    Note SOL4(392, true, &multiplier, di.getDiesisPointer());
    Note SI4(494, false, &multiplier, di.getDiesisPointer());
    Note LA4(440, true, &multiplier, di.getDiesisPointer());

    ButtonMusical a (PTA1, DO4, &speaker);
    ButtonMusical b (PTA2, RE4, &speaker);
    ButtonMusical c (PTD4, MI4, &speaker);
    ButtonMusical d (PTA12, FA4, &speaker);
    ButtonMusical e (PTD5, SOL4, &speaker);
    ButtonMusical f (PTD0, LA4, &speaker);
    ButtonMusical g (PTD2, SI4, &speaker);

    while (true) {
        lcd.cls();
        menuManager();
        switch(mode) {
            case OCTAVE:
                octaveSettings();
                break;
            case VOLUME:
                volumeSettings(volume);
                break;
            case METRONOME:
                metronomeSettings(&bpm);
                break;
            default:
                mode=OCTAVE;
                break;
        }
    }
}