#include "mbed.h"
#include "init.h"

//  --------------------------------------   ADC   ----------------------------
void sample_adc() {
    BUSY = 1;
    char adc_byte[2];
    char man_reg_adr[3];
    char val_reg_adr[2];
    char conv_res[1];
    uint16 *adc_ptr = ADC_BUF;

    if (ADC_CMD->adc_reg_width == 1) {
        memcpy(&man_reg_adr, (char *)&ADC_CMD->man_trig_reg, 1);
        man_reg_adr[1] = ADC_CMD->man_trig_val;
        memcpy(&val_reg_adr, (char *)&ADC_CMD->adc_lsb_reg, 1);        
    } else {
        memcpy(&man_reg_adr, (char *)&ADC_CMD->man_trig_reg, 2);
        man_reg_adr[2] = ADC_CMD->man_trig_val;
        memcpy(&val_reg_adr, (char *)&ADC_CMD->adc_lsb_reg, 2);
    }

    for(int n = 0; n < ADC_CMD->adc_samples; n++) {
        if (ADC_CMD->man_conv_mask != 0xFF) {
            // send i2c cmd to trigger manual conversion
            if (ADC_CMD->adc_reg_width == 1) {
                mI2C.write(ADC_CMD->slv_addr, man_reg_adr, 2);
            } else {
                mI2C.write(ADC_CMD->slv_addr, man_reg_adr, 3);
            }
            
            // wait 100us to avoid conversion noise due to communication 
            wait_us(100);
                        
            // loop until manual conversion done
            conv_res[0] = 0xFF;
            while (conv_res[0] != ADC_CMD->man_conv_mask) {
                if (ADC_CMD->adc_reg_width == 1) {
                    mI2C.write(ADC_CMD->slv_addr, man_reg_adr, 1, true);
                } else {
                    mI2C.write(ADC_CMD->slv_addr, man_reg_adr, 2, true);
                }            
                mI2C.read((ADC_CMD->slv_addr), conv_res, 1);
            }
        }
        if (ADC_CMD->adc_reg_width == 1) {
            mI2C.write(ADC_CMD->slv_addr, val_reg_adr, 1, true);
        } else {
            mI2C.write(ADC_CMD->slv_addr, val_reg_adr, 2, true);
        }
        mI2C.read(ADC_CMD->slv_addr, adc_byte, 2);
        memcpy(adc_ptr, (uint16*) adc_byte, 2);
        //pc.printf("adc_adr= 0x%X   adc_ptr= 0x%04X\n\r", adc_ptr, *adc_ptr);
        adc_ptr++;
    }
    BUSY = 0;
}

//  --------------------------------------   DAC   ----------------------------
void dac_wr(byte *cmd) {
    cs0 = 0;
    for (byte i=0;i<3;i++){
      spi.write(cmd[i]);
    }
    cs0 = 1;
}

byte* dac_rd() {
    static byte response[3];
    cs0 = 0;
    for (byte i=0;i<3;i++){
        response[i] = spi.write(0xFF);
    }
    cs0 = 1;
    return response;
}

void set_dac() {
    cs0 = 0;
    for (byte i=2;i<5;i++){
        //pc.printf("i=%i dac=0x%02X\n\r", i, INBUF[i]);
        spi.write(INBUF[i]);
    }
    cs0 = 1;
    wait_us(500.0);
}


// ---------------------------------------  MAIN  -----------------------------
int main() {
    int i = 0;
    byte ADC_START = 0;
    byte cmd = 0;
    byte dac_cntrl[3];
    sI2C.address(mbed_SlaveAddr);     //8-bit definition
    mI2C.frequency(400000);
    sI2C.frequency(400000);

    cs0 = 1;
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 500kHz clock rate
    spi.format(8, 2);
    spi.frequency(500000);
    dac_wr(DAC_INIT_CMD);       // init dac
    dac_wr(DAC_ZERO_CMD);       // to avoid negative level at startup
    sI2C.read(INBUF, sizeof(INBUF));    // empty the i2c buffer
    #ifdef debug
         pc.baud(115200);
         pc.printf("ADC-Sampling\n\r");
    #endif
        
    while (1) {
        i = sI2C.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:       // i2c state 1
//                 pc.printf("i2c read\n\r");
//                 for(int n = 0; n < ADC_CMD->adc_samples; n++) {
//                     pc.printf("n=%i adc=0x%04X  ptr=0x%04X\n\r", n, ADC_BUF[n], &ADC_BUF[n]);
//                 }
                switch (cmd) {
                    case CMD_ADC_RD:
                        sI2C.write((char*)ADC_BUF, ADC_CMD->adc_samples*sizeof(uint16));
                        led_1 = 0;
                        break;
                    case CMD_ID:
                        sI2C.write(IDSTR, sizeof(IDSTR));
                        break;
                    case CMD_DAC_RD:
                        byte * dac_response = dac_rd();
                        sI2C.write((char*) dac_response, 3);
                        break;
                }         
                break;
            
            case I2CSlave::WriteAddressed:      // i2c state 3
                //pc.printf("i2c rec  %d\n\r" , cmd_len);
                sI2C.read(INBUF, sizeof(INBUF));
                cmd = INBUF[0];
                switch (cmd) {
                   case CMD_ADC:
                        memcpy(ADC_CMD, &INBUF[2], sizeof(ADC_CmdSet));                     
                        led_1 = 1;
                        ADC_START = 1;
                        break;
                    case CMD_DAC:
                        set_dac();
                        break;
                    case CMD_VSAMPL:
                        set_dac();
                        memcpy(ADC_CMD, &INBUF[5], sizeof(ADC_CmdSet)); 
                        led_1 = 1;
                        ADC_START = 1;
                        break;
                    case CMD_IDAC:
                        //pc.printf("i2c CMD_IDAC  0x%02X\n\r" , INBUF[1]);
                        dac_wr(DAC_INIT_CMD);     // init dac
                        dac_wr(DAC_ZERO_CMD);     // to avoid negative level
                        break;
                    case CMD_DAC_WR:
                        //pc.printf("i2c CMD_DAC_WR  0x%02X\n\r" , INBUF[1]);
                        memcpy(dac_cntrl, &INBUF[1], sizeof(dac_cntrl));
                        dac_wr(dac_cntrl);
                        break;
                }
                break;
            case I2CSlave::WriteGeneral:        // i2c state 2
                break;
        }
        if (ADC_START == 1 && BUSY == 0) {
            sample_adc();
            ADC_START = 0;
        }
    }
}
