#define byte unsigned char
#define uint32 unsigned long
#define uint16 unsigned short
//#define debug 1
#define BUF_SIZE  512

/* Test specific constants  */
#define CMD_ID         0x00    // return requested ID msg
#define CMD_ADC        0x01    // trigger ADC sampling loop
#define CMD_DAC        0x21    // control the DAC
#define CMD_IDAC       0x22    // send DAC init command
#define CMD_DAC_WR     0x23    // send DAC control command
#define CMD_ADC_RD     0x81    // requested ADC values
#define CMD_VSAMPL     0x82    // set DAC and sample adc values
#define CMD_DAC_RD     0x83    // read DAC register

// some more may be added

#define mbed_SlaveAddr 0x22

__packed struct ADC_CmdSet {
    byte        adc_reg_width;  /* 1 or 2 byte register address width         */
    byte        adc_samples;    /* Number of ADC samples per DAC step         */
    byte        slv_addr;       /* pmic slave address                         */
    uint16      man_trig_reg;   /* register address to control manual conv.   */
    byte        man_trig_val;   /* adc manual control value                   */
    byte        man_conv_mask;  /* adc mask to detect manuanl conv. done      */
    uint16      adc_lsb_reg;    /* register address for adc value readout     */
};


char INBUF[64]; // set to the biggest CmdSet

// reserve data buffer unsigned int for adc values
uint16 ADC_BUF[BUF_SIZE] __attribute__ ((section("AHBSRAM0")));

DigitalOut led_1(LED1);
DigitalOut cs0(p8);  // SYNC signal for DAC

I2C mI2C(p28, p27);
I2CSlave sI2C(p9, p10);
SPI spi(p5, p6, p7); // mosi, miso, sclk
#ifdef debug
    Serial pc(USBTX, USBRX);
#endif

char IDSTR[] = "mbed_DAC-ADC-control rev 1.1\n";
// SDODIS=0, 2sC=1, DACTRI=0, OPGND=0, RBUF=1, RW=0, Control Register
byte DAC_INIT_CMD [3] = {0x20, 0x00, 0x12}; // MSB first
byte DAC_ZERO_CMD [3] = {0x18, 0x00, 0x00}; // 0V if VREFpos = 5V and VREFneg = -5V

char BUSY = 0;
char ADC_SAMPLES = 0;
struct ADC_CmdSet ADC_CMD[1];


void sample_adc();
void dac_wr(byte *cmd);
void set_dac(byte *dn_value);
