#include "mbed.h"
DigitalOut EN_LOAD_TRANS(p5);
DigitalOut EN_LOAD5(p6);               // 10R
DigitalOut EN_LOAD6(p7);               // 5R
DigitalOut EN_LOAD1(p8);               // 2R
DigitalOut EN_LOAD2(p9);               // 1R
DigitalOut EN_SHORT(p10);
DigitalOut EN_GATE_SHORT(p11);
DigitalOut EN_VBUS_IN(p12);
DigitalOut EN_LINE_TRANS(p13);
DigitalOut EN_HV2(p14);
DigitalOut EN_HV1(p15);
DigitalOut EN_LOAD7(p16);               // 2R
DigitalOut EN_LOAD8(p17);               // 5R
DigitalOut EN_LOAD3(p18);               // 10R
DigitalOut EN_LOAD4(p19);               // 10R
DigitalOut TRIGGER_OUT(p27);
DigitalIn TRIGGER_IN(p28);
DigitalIn  OP_0(p30);
DigitalIn  OP_1(p29);

#define LOAD_0A EN_LOAD_TRANS = 0
#define LOAD_3A EN_LOAD1 = 0; EN_LOAD3 = 1; EN_LOAD5 = 0; EN_LOAD6 = 1; EN_LOAD7 = 1; EN_LOAD8 = 0
#define LOAD_6A EN_LOAD1 = 1; EN_LOAD3 = 0; EN_LOAD5 = 1; EN_LOAD6 = 1; EN_LOAD7 = 1; EN_LOAD8 = 1
#define HV_TO_LV EN_HV1 = 0
#define LV_TO_HV EN_HV1 = 1

/*
InterruptIn TRIGGER_IN(p28);

void pressed()
{
    if (delay == 1.0)
        delay = 0.2; // 200 ms
    else
        delay = 1.0; // 1 sec
}
*/


int main() {
    unsigned char operation;
    EN_LOAD_TRANS = 0;
    EN_LINE_TRANS = 1;
    EN_SHORT = 1;
    EN_HV1 = 1;
    EN_HV2 = 0;
    EN_GATE_SHORT = 0;
    EN_VBUS_IN = 1;
    EN_LOAD1 = 0;
    EN_LOAD2 = 0;
    EN_LOAD3 = 0;
    EN_LOAD4 = 0;
    EN_LOAD5 = 0;
    EN_LOAD6 = 0;
    EN_LOAD7 = 0;
    EN_LOAD8 = 0;
    
    if ((OP_0) and (OP_1)) {
        operation = 3;  // short to gnd
    }
    if ((OP_0) and (!OP_1)) {
        operation = 2;  // combo
    }
    if ((!OP_0) and (OP_1)) {
        operation = 1;  // line transient
    }
    if ((!OP_0) and (!OP_1)) {
        operation = 0;  // load transient
    }

    while(1) {
        if ((operation == 0) and (TRIGGER_IN == 1))   // load transient
        {
            TRIGGER_OUT = 1;
            EN_LOAD_TRANS = 1;
            LOAD_3A;
            wait_us(250);
            TRIGGER_OUT = 0;
            LOAD_0A;
            wait_ms(10);    
        }
         if ((operation == 1) and (TRIGGER_IN == 1))   // line transient
        {
            TRIGGER_OUT = 1;
            EN_LINE_TRANS = 1;
            EN_HV1 = 0;
            wait_us(100);
            TRIGGER_OUT = 0;
            EN_HV1 = 1;
            wait_ms(10);           
        }
         if ((operation == 2) and (TRIGGER_IN == 1))   // combo transient
        {
            TRIGGER_OUT = 1;
            EN_LINE_TRANS = 1;
            EN_LOAD_TRANS = 1;
            
            LOAD_0A;            // 1 POS    
            wait_ms(1);
            LV_TO_HV;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_3A;
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            HV_TO_LV;
            wait_ms(10);
            TRIGGER_OUT = 0;
            
            LV_TO_HV;           // 2 POS    
            EN_LOAD_TRANS = 1;
            wait_us(7);
            LOAD_3A;
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            HV_TO_LV;
            wait_ms(10);         
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 3 POS
            wait_us(500);
            LV_TO_HV;
            wait_us(500);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            HV_TO_LV;
            wait_ms(10);             
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 4 POS
            wait_ms(1);
            LV_TO_HV;
            wait_us(3);// add to sychronize with VBUS rise front
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            HV_TO_LV;
            wait_ms(10);             
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 5 POS
            wait_ms(1);
            LOAD_6A;
            wait_us(500);
            LV_TO_HV;
            wait_us(503);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            HV_TO_LV;
            wait_ms(10);             
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 6 POS
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LV_TO_HV;
            wait_us(3);// add to sychronize with VBUS rise front
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            HV_TO_LV;
            wait_ms(10); 
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 7 POS
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LV_TO_HV;
            wait_us(8);// add to sychronize with VBUS rise front
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            HV_TO_LV;
            wait_ms(10); 
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 8 POS
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            LV_TO_HV;
            EN_LOAD_TRANS = 1;
            wait_us(3);// add to sychronize with VBUS rise front
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            HV_TO_LV;
            wait_ms(10); 
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 9 POS
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LV_TO_HV;
            wait_us(5);// add to sychronize with VBUS rise front
            LOAD_0A;
            wait_ms(20); 

            LOAD_0A;            // 1 NEG   
            wait_ms(1);
            HV_TO_LV;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_3A;
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            LV_TO_HV;
            wait_ms(10);
            
            HV_TO_LV;           // 2 NEG     
            EN_LOAD_TRANS = 1;
            wait_us(15);// add to sychronize with VBUS rise front
            LOAD_3A;
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            LV_TO_HV;
            wait_ms(10);         
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 3 NEG 
            wait_us(500);
            HV_TO_LV;
            wait_us(500);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            LV_TO_HV;
            wait_ms(10);             
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 4 NEG 
            wait_ms(1);
            HV_TO_LV;
            wait_us(10);// add to sychronize with VBUS rise front
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            LV_TO_HV;
            wait_ms(10);             
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 5 NEG 
            wait_ms(1);
            LOAD_6A;
            wait_us(500);
            HV_TO_LV;
            wait_us(500);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            LV_TO_HV;
            wait_ms(10);             
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 6 NEG 
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            HV_TO_LV;
            wait_us(10);// add to sychronize with VBUS rise front
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            LV_TO_HV;
            wait_ms(10); 
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 7 NEG 
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            HV_TO_LV;
            wait_us(15);// add to sychronize with VBUS rise front
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            LV_TO_HV;
            wait_ms(10); 
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 8 NEG 
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            HV_TO_LV;
            EN_LOAD_TRANS = 1;
            wait_us(15);// add to sychronize with VBUS rise front
            LOAD_6A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            LV_TO_HV;
            wait_ms(10); 
            
            EN_LOAD_TRANS = 1;
            LOAD_3A;            // 9 NEG 
            wait_ms(1);
            LOAD_6A;
            wait_ms(1);
            LOAD_3A;
            wait_ms(1);
            LOAD_0A;
            wait_ms(1);
            EN_LOAD_TRANS = 1;
            LOAD_6A;
            wait_ms(1);
            HV_TO_LV;
            wait_us(10);// add to sychronize with VBUS rise front
            LOAD_0A;
            wait_ms(10);
            wait_ms(20); 
        }
         if ((operation == 3) and (TRIGGER_IN == 1))   // short to GND
        {
            EN_GATE_SHORT = 1;
            wait_ms(1);
            EN_VBUS_IN = 0;
            wait_ms(1);
            EN_GATE_SHORT = 0;
            wait_ms(50);
            EN_VBUS_IN = 1;
            wait_ms(50);
            
            
        }

 

 

    }
}
