#include "mbed.h"

int main()
{
    Serial pc(USBTX, USBRX);
    
    /** STMicro Nucelo F401RE/L152RE
    * The supported jumper configurations of the MTSAS do not line up with
    * the pin mapping of the Nucleo. Therefore, the MTSAS serial TX
    * pin (JP8 Pin 2) must be manually jumped to Serial1 RX (Shield pin D2)
    * and the MTSAS serial RX pin (JP9 Pin 2) pin must be manually jumped to
    * Serial1 TX (Shield pin D8).
    * Uncomment the following line to use the STMicro Nuceleo
    */
    Serial device(D8, D2);
    
    /** Freescale KL25Z
    * To configure the serial pins for the Freescale KL25Z board, use MTSAS jumper
    * configuration C. Uncomment the following line to use the Freescale KL25Z board
    */
    //Serial device(D9, D2);
    
    /** Freescale KL46Z
    * To configure the serial pins for the Freescale KL46Z board, use MTSAS jumper 
    * configuration B. Uncomment the following line to use the Freescale KL46Z board
    */
    //Serial device(D2, D9);
    
    /** Freescale K64F
    * To configure the serial pins for the Freescale K64F board, use MTSAS jumper
    * configuration A. Uncomment the following line to use the Freescale K64F board
    */
    //Serial device(D1, D0);

    int device_baud = 115200;
    int pc_baud = 115200;

    device.baud(device_baud);
    pc.baud(pc_baud);
    
    pc.printf("starting passthrough to radio\r\n");
    
    while (true) {
        if (pc.readable())
            device.putc(pc.getc());
            
        if (device.readable())
            pc.putc(device.getc());
    }
}