#include "mbed.h"
#include "FXLS8471Q.h"
#include "MPL3115A2.h"

#define MPL3115A2_I2C_ADDRESS (0x60<<1)

/* NOTE
 * Nucleo boards need extra jumpers for this code to function properly.
 * See (3) in the "Shields Support Notes" section of http://developer.mbed.org/platforms/ST-Nucleo-F401RE/
 */

int main() {
    // accelerometer
    FXLS8471Q acc(D11, D12, D13, D10);
    float acc_data[3];
    
    // temperature/pressure sensor
    MPL3115A2 tmp(D14, D15, MPL3115A2_I2C_ADDRESS, D3, D4);
    tmp.Barometric_Mode();
    
    while (true) {
        acc.ReadXYZ(acc_data);
        printf("x: %1.4f g\ty: %1.4f g\tz: %1.4f g\r\n", acc_data[0], acc_data[1], acc_data[2]);
        
        printf("temperature: %f C\tpressure: %f Pa\r\n", tmp.getTemperature(), tmp.getPressure());
        
        wait(2);
    }
    
    return 0;
}