#include "mbed.h"
#include "MTSSerialFlowControl.h"
#include <string>

using namespace mts;

char pattern[] = "0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24  \r\n"
"1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25  \r\n"
"2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26  \r\n"
"3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27  \r\n"
"4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28  \r\n"
"5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29  \r\n"
"6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30  \r\n"
"7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31  \r\n"
"8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32  \r\n"
"9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33  \r\n"
"10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34  \r\n"
"11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35  \r\n"
"12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36  \r\n"
"13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37  \r\n"
"14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38  \r\n"
"15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39  \r\n"
"16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40  \r\n"
"17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41  \r\n"
"18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42  \r\n"
"19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43  \r\n"
"20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44  \r\n"
"21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45  \r\n"
"22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46  \r\n"
"23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47  \r\n"
"24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48  \r\n"
"25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49  \r\n"
"26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50  \r\n"
"27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51  \r\n"
"28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52  \r\n"
"29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53  \r\n"
"30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54  \r\n"
"31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55  \r\n"
"32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56  \r\n"
"33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57  \r\n"
"34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58  \r\n"
"35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59  \r\n"
"36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60  \r\n"
"37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61  \r\n"
"38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62  \r\n"
"39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63  \r\n"
"40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64  \r\n"
"41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65  \r\n"
"42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66  \r\n"
"43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67  \r\n"
"44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68  \r\n"
"45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69  \r\n"
"46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70  \r\n"
"47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71  \r\n"
"48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72  \r\n"
"49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73  \r\n";

int main() {
    
    int baud = 115200;
    int mybufsize = 1024;
    char mybuf[mybufsize];
    int readsize = 0;
    string data;
    int index = 0;
    bool loss = false;
    
    // STMicro Nucleo F401RE
    //DigitalIn sw(USER_BUTTON);
    //MTSSerialFlowControl* io = new MTSSerialFlowControl(D8, D2, D3, D6);
    
    // Freescale KL46Z
    DigitalIn sw(PTC12);
    MTSSerialFlowControl* io = new MTSSerialFlowControl(D2, D9, D3, D6);
    
    // Freescale K64F
    //DigitalIn sw(PTA4);
    //MTSSerialFlowControl* io = new MTSSerialFlowControl(D1, D0, D3, D6);
    
    io->baud(baud);
    
    printf("baud rate at %d\r\n", baud);
    
    while (true) {
        printf("reading\r\n");
        data.clear();
        loss = false;
        while (sw == 1) {
            if (io->readable()) {
                readsize = io->read(mybuf, mybufsize, 250);
                if (readsize > 0) {
                    data.append(mybuf, readsize);
                    printf("read %d total bytes\r\n", data.size());
                } else {
                    printf("read failed\r\n");
                }
            }
        }
        wait(1);

        for (index = 0; index < data.size(); index++) {
            if (pattern[index] != data[index]) {
                printf("data loss at index %d\r\n", index);
                printf("expecting [%02X] found [%02X]\r\n", pattern[index], data[index]);
                loss = true;
                break;
            }
        }

        if (loss) {
            printf("full pattern [\r\n");
            printf("%s", pattern);
            printf("]\r\n");
            printf("full data [\r\n");
            printf("%s", data.c_str());
            printf("]\r\n");
            printf("\r\n");
            
            printf("lost %d bytes\r\n", sizeof(pattern) - data.size());
        } else {
            printf("no data loss\r\n");
        }
        
        while (sw == 1);
        wait(1);
    }
}