#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include "MTSText.h"
#include <string>
#include <vector>

using namespace mts;

static std::string config_network_name = "";
static std::string config_network_pass = "";
static uint8_t config_frequency_sub_band = 1;

int main() {
    Serial debug(USBTX, USBRX);
    debug.baud(460800);
    
    int32_t ret;
    int32_t next_tx;
    int32_t wait_time = 2;
    mDot* dot;
    std::vector<uint8_t> send_data;
    std::vector<uint8_t> recv_data;
    uint8_t recv = 0;
    uint8_t recv_mismatch = 0;
    uint8_t send_failure = 0;
    uint8_t iterations = 50;
    
    send_data.push_back(0x00);
    send_data.push_back(0xFF);
    send_data.push_back(0xFF);
    send_data.push_back(0xFF);
    send_data.push_back(0xFF);
    send_data.push_back(0xFF);
    send_data.push_back(0xFF);
    send_data.push_back(0xFF);

    dot = mDot::getInstance();

    dot->resetConfig();
    
    dot->setLogLevel(MTSLog::TRACE_LEVEL);

    while ((ret = dot->setFrequencySubBand(config_frequency_sub_band)) != mDot::MDOT_OK) {
        logError("failed to set frequency sub band: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
    }
    while ((ret = dot->setNetworkName(config_network_name)) != mDot::MDOT_OK) {
        logError("failed to set network name: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
    }
    while ((ret = dot->setNetworkPassphrase(config_network_pass)) != mDot::MDOT_OK) {
        logError("failed to set network password: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
    }

    logInfo("enabling activity LED");
    dot->setActivityLedEnable(true);

    logInfo("joining network");
    while ((ret = dot->joinNetwork()) != mDot::MDOT_OK) {
        logError("failed to join network: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
        wait_ms(dot->getNextTxMs() + 1);
    }
    logInfo("joined");

    for (uint8_t i = 0; i < iterations; i++) {
        send_data[0] = i;
        if ((ret = dot->send(send_data)) != mDot::MDOT_OK) {
            logError("failed to send: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
            send_failure++;
        } else {
            logInfo("send data: %s", Text::bin2hexString(send_data).c_str());
            if ((ret = dot->recv(recv_data)) != mDot::MDOT_OK) {
                logError("failed to recv: [%d][%s]", ret, mDot::getReturnCodeString(ret).c_str());
            } else {
                logInfo("recv data: %s", Text::bin2hexString(recv_data).c_str());
                if (recv_data == send_data) {
                    recv++;
                } else {
                    recv_mismatch++;
                }
            }
            recv_data.clear();
        }
        
        next_tx = dot->getNextTxMs() + 1;
        logInfo("waiting %ld ms to transmit again", next_tx);
        wait_ms(next_tx);
        logInfo("waiting another %d seconds", wait_time);
        wait(wait_time);
    }
    
    logInfo("Version: %s", dot->getId().c_str());
    logInfo("Recv: %d/%d", recv, iterations);
    logInfo("Recv Mismatch: %d/%d", recv_mismatch, iterations);
    logInfo("Send Failure: %d/%d", send_failure, iterations);
    logInfo("Dropped: %d/%d", iterations - (recv + recv_mismatch + send_failure), iterations);

    return 0;
}