#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include <vector>

Serial pc(USBTX, USBRX);

int main()
{
    mDot* dot;
    std::vector<mDot::mdot_file> files;
    mDot::mdot_file file;
    const char filename[] = "test_file.txt";
    uint8_t buf[1024];
    
    pc.baud(115200);

    // get a mDot handle
    dot = mDot::getInstance();
    dot->resetConfig();
    dot->saveConfig();
    
    mts::MTSLog::setLogLevel(mts::MTSLog::INFO_LEVEL);

    // print library version information
    logInfo("version: %s", dot->getId().c_str());

    logInfo("deleting user files");
    files = dot->listUserFiles();
    for (std::vector<mDot::mdot_file>::iterator it = files.begin(); it != files.end(); it++) {
        printf("\tdeleting %s [%d]\r\n", it->name, it->size);
        dot->deleteUserFile(it->name);
    }

    memset(buf, 0x3B, sizeof(buf));

    logInfo("creating 1kB file of 0x3B");
    file = dot->openUserFile(filename, mDot::FM_RDWR | mDot::FM_CREAT | mDot::FM_APPEND);
    if (file.fd < 0) {
        logError("failed to open file");
    } else {
        if (dot->writeUserFile(file, (void*)buf, sizeof(buf)) != sizeof(buf)) {
            logError("didn't write entire buffer");
        }

        dot->closeUserFile(file);
    }

    for (int i = 0; i < 10; i++) {
        uint8_t buf[8];
        uint32_t loc;
        
        memset(buf, 0xA2, sizeof(buf));
        
        file = dot->openUserFile(filename, mDot::FM_RDWR);
        if (file.fd < 0) {
            logError("failed to open file");
            break;
        } else {
            loc = (uint32_t)(rand() % (file.size - sizeof(buf)));
            logInfo("seeking to 0x%04X", loc);
            if (! dot->seekUserFile(file, loc, SEEK_SET)) {
                logError("seek failed");
                break;
            }
            logInfo("writing %d '0xA2' bytes to 0x%04X", sizeof(buf), loc); 
            if (dot->writeUserFile(file, (void*)buf, sizeof(buf)) != sizeof(buf)) {
                logError("didn't write entire buffer");
                break;
            }

            dot->closeUserFile(file);
        }
    }
    
    file = dot->openUserFile(filename, mDot::FM_RDONLY);
    if (file.fd < 0) {
        logError("failed to open file");
    } else {
        uint8_t buf[16];
        uint32_t read = 0;
        uint32_t ret = 0;

        logInfo("file data:");
        while (read < file.size) {
            ret = dot->readUserFile(file, (void*)buf, sizeof(buf));
            if (ret > 0) {
                printf("0x%04X\t", read);
                for (int i = 0; i < ret; i++) {
                    printf("%02X ", buf[i]);
                }
                printf("\r\n");
                read += ret;
            } else {
                logError("error reading file");
                break;
            }
        }

        dot->closeUserFile(file);
    }

    return 0;
}
