#include "mbed.h"
#include "mtsas.h"

AnalogIn light(A0);
AnalogIn temp(A1);
DigitalOut led(D4);

bool lights_on() {
    float val = light.read();
    if (val > 0.4f)
        return true;
    return false;
}

float get_temp_c() {
    int beta = 3975;
    int val = temp.read_u16();
    float res = (float) 10000.0 * ((65536.0 / val) - 1.0);
    float temp_c = (1 / ((log(res / 5000.0) / beta) + (1.0 / 298.15))) - 273.15 - 7;
    
    return temp_c;
}

float get_temp_f() {
    float temp_f = get_temp_c() * 9 / 5 + 32;
    
    return temp_f;
}

int main() {
    while (true) {
        printf("temp: %f C\t %f F\r\n", get_temp_c(), get_temp_f());
        if (lights_on()) {
            printf("lights on!\r\n");
            led = 0;
        } else {
            printf("lights off!\r\n");
            led = 1;
        }
        wait(2);
    }
    
    return 0;
}
