#include "mbed.h"
#include "x_nucleo_53l0a1.h"
#include <stdio.h>

/* This VL53L0X Expansion board test application performs a range measurement in polling mode
   on the onboard embedded top sensor. */

#define VL53L0_I2C_SDA   D14 
#define VL53L0_I2C_SCL   D15 

static X_NUCLEO_53L0A1 *board=NULL;


/*=================================== Main ==================================
=============================================================================*/
int main()
{   
   int status;
   uint32_t distance;

   DevI2C *device_i2c =new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);     
        
   /* creates the 53L0A1 expansion board singleton obj */
   //board=X_NUCLEO_53L0A1::Instance(device_i2c, A2, D8, D2);
   board=X_NUCLEO_53L0A1::Instance(device_i2c, A2, D7, D2);

   /* init the 53L0A1 expansion board with default values */
   status=board->InitBoard();
   if(status) { printf("Failed to init board!\n\r"); return 0; }

   while(1)
   {
       status = board->sensor_centre->GetDistance(&distance);
       if (status == VL53L0X_ERROR_NONE)
           printf("Distance : %ld\n", distance);
   }

}

