#include "mbed.h"
#include "DisplayManager.h"

DisplayManager::DisplayManager(PinName clk, PinName dio) : display(NULL) {
    display = new DigitDisplay(clk, dio);
}

DisplayManager::~DisplayManager() {
    if (display) delete display;
}

uint8_t DisplayManager::convert(uint8_t value) {
    switch (value) {
        case '0':
            return 0x3f;
        case '1':
            return 0x06;
        case '2':
            return 0x5b;
        case '3':
            return 0x4f;
        case '4':
            return 0x66;
        case '5':
            return 0x6d;
        case '6':
            return 0x7d;
        case '7':
            return 0x07;
        case '8':
            return 0x7f;
        case '9':
            return 0x6f;
        case 'a':
        case 'A':
            return 0x77;
        case 'b':
        case 'B':
            return 0x7c;
        case 'c':
        case 'C':
            return 0x39;
        case 'd':
        case 'D':
            return 0x5e;
        case 'e':
        case 'E':
            return 0x79;
        case 'f':
        case 'F':
            return 0x71;
        case 'g':
        case 'G':
            return 0x3d;
        case 'h':
        case 'H':
            return 0x76;
        case 'i':
        case 'I':
            return 0x30;
        case 'j':
        case 'J':
            return 0x1e;
        case 'k':
        case 'K':
            return 0x76;
        case 'l':
        case 'L':
            return 0x38;
        case 'm':
        case 'M':
            return 0x15;
        case 'n':
        case 'N':
            return 0x54;
        case 'o':
        case 'O':
            return 0x3f;
        case 'p':
        case 'P':
            return 0x73;
        case 'q':
        case 'Q':
            return 0x67;
        case 'r':
        case 'R':
            return 0x50;
        case 's':
        case 'S':
            return 0x6d;
        case 't':
        case 'T':
            return 0x78;
        case 'u':
        case 'U':
            return 0x3e;
        case 'v':
        case 'V':
            return 0x1c;
        case 'w':
        case 'W':
            return 0x2a;
        case 'x':
        case 'X':
            return 0x76;
        case 'y':
        case 'Y':
            return 0x6E;
        case 'z':
        case 'Z':
            return 0x5b;
        case '-':
            return 0x40;
        case '_':
            return 0x08;
            
        default:
            return 0x00;
    }
}

void DisplayManager::showMessage(char* message, int len) {
    int shifts = 0;
    char* cur = &message[0];
    char* back = &message[len - 1];
    uint8_t buf[4] = { 0x00, 0x00, 0x00, 0x00 };
    
    while (shifts <= len + 4) {
        buf[0] = buf[1];
        buf[1] = buf[2];
        buf[2] = buf[3];
        if (cur == back) {
            buf[3] = 0x00;
        } else {
            buf[3] = convert(*cur);
            cur++;
        }
        
        shifts++;
        display->writeRaw(buf);
        wait(0.5);
    }
    
    wait(1);
}

void DisplayManager::clear() {
    display->clear();
}