#include "mbed.h"
#include "mtsas.h"
#include "PubSubClient.h"

/* PLEASE READ THIS!
 * The following fields must be populated in order to properly send data to the "Default ThingFabric Project" in your 2lemetry account using the MQTT client
 * You must have a hacker (or higher) account at http://app.thingfabric.com
 * After you register and login, follow the steps below to set up your client
 * Click on "Default ThingFabric Project"
 *      Set _2LEMETRY_DOMAIN to the string after "Project" at the top of the page
 * Click on "Credentials"
 * Click on "Default ThingFabric Credential"
 *      Set _2LEMETRY_USER_ID to the value in the "Key (Username)" field
 *      Set _2LEMETRY_TOKEN to the value in the "MD5 Secret" field
 * If you are running this code on multiple devices, you will want to make the _2LEMETRY_DEVICE_ID field unique for each device
 * Set the _APN field to the APN provided with your sim card
 * Build, flash, and run
 *      This code sends a random integer value approximately every 30 seconds
 * Click on "Default ThingFabric Project"
 * Click on "Analytics"
 * You should be able to see your test data (page needs to be refreshed periodically, it doesn't automatically refresh)
 */

char _2LEMETRY_USERID[] = "";
char _2LEMETRY_TOKEN[] = "";
char _2LEMETRY_DOMAIN[] = "";
char _2LEMETRY_STUFF[] = "things";
char _2LEMETRY_DEVICE_ID[] = "nucleo-0001";

char _APN[] = "";

char _host[] = "q.mq.tt";
int _port = 1883;

void callback(char* topic, char* payload, unsigned int len) {
    logInfo("topic: [%s]\r\npayload: [%s]", topic, payload);
}

int main() {
    MTSLog::setLogLevel(MTSLog::TRACE_LEVEL);
    
    // for Nucleo boards
    MTSSerialFlowControl io(D8, D2, D3, D6);
    io.baud(115200);
    
    Cellular* radio = CellularFactory::create(&io);
    if (! radio) {
        logFatal("failed to create Cellular object - exiting");
        return 1;
    }
    
    radio->configureSignals(D4,D7,RESET);
    Transport::setTransport(radio);
    
    while (radio->setApn(_APN) != MTS_SUCCESS) {
        logError("failed to set APN [%s]", _APN);
        wait(2);
    }
    
    while (! radio->connect()) {
        logError("failed to bring up PPP link");
        wait(2);
    }
    
    PubSubClient mqtt(_host, _port, callback);
    
    char topicStr[128];
    char buf[64];
    snprintf(topicStr, sizeof(topicStr), "%s/%s/%s", _2LEMETRY_DOMAIN, _2LEMETRY_STUFF, _2LEMETRY_DEVICE_ID);
    
    while (true) {
        if (! mqtt.connect(_2LEMETRY_DEVICE_ID, _2LEMETRY_USERID, _2LEMETRY_TOKEN)) {
            logError("failed to connect to 2lemetry server");
            continue;
        }
        snprintf(buf, sizeof(buf), "{\"test\":%d}", rand());
        logInfo("publishing: [%s]", buf);
        if (! mqtt.publish(topicStr, buf)) {
            logError("failed to publish: [%s]", buf);
        }
        wait(1);
        mqtt.loop();
        mqtt.disconnect();
        wait(30);
    }
    
    return 0;
}