#include "mbed.h"
#include "SI1143.h"
#include "m3pi.h"
#define NN 1000

//DigitalOut enable(p30);
//Ticker timer;

I2C* i2c = new I2C(p28, p27);
Serial bt(p13, p14);
m3pi pi;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

InterruptIn event(p26);

SI1143 sensor1(i2c, p30, p29, 0x01);
//SI1143 sensor2(i2c, p25, p26, 0x02); // p25, p26

//InterruptIn prox_meas(p26); //26
int sense1a, sense1b, sense2a, sense2b;
int sensor1alog[NN];
int sensor1blog[NN];
int whileflag = 1;
int countingstuffpoop = 0;

float alpha = 0.999;
float beta;
float floorpoop = 225;
float stdpoop =  5;
float scalepoop = 5;
int cd = 5;

void meas_int()
{
    led1 = 1;
    sense1a = sensor1.read_ps1();
    sense1b = sensor1.read_ps2();
    if(sense1a > floorpoop)
    {
        floorpoop = floorpoop*(1+beta);    
    }
    else
    {
        floorpoop = floorpoop*(1-beta);
    }

    if(sqrt(((float) sense1a - floorpoop)*(sense1a - floorpoop)) > stdpoop)
    {
        stdpoop = stdpoop*(1+beta);    
    }
    else
    {
        stdpoop = stdpoop*(1-beta);
    }
    
    if(sense1a > floorpoop + scalepoop*stdpoop)
    {
        led4 = 1;
        cd = 20;
    }
    else
    {
        cd = cd - 1;
        if(cd < 0)
        {
            cd = - 1;
            led4 = 0;
        }   
    }    
    sensor1.clear_int();
    led1 = 0;
}

void blinkblink(int t, int n)
{
    for (int i = 1; i <= n; i++)
    {
    led4 = 1;
    wait(t);
    led4 = 0;
    wait(t);    
    }
}

int main()
{
    led2 = 0;
    //wait(10);
    blinkblink(1,2);
    beta = 1-alpha;
    event.fall(&meas_int);
    //timer.attach(&meas_int, 0.01);
    sensor1.start_ps_auto();
    led4 = 1;
    //pi.left(0.1);

    //pi.stop();
    blinkblink(1,5);
    
    led1 = 1;
    wait(0.3);
    led1 = 0;
    wait(0.3);
    led1 = 1;
    while(1)
    {
        
    }
}