#include "mbed.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
DigitalOut led(PTC12);

int main(void) {
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);

    while (true) {
        //rled = 1.0 - abs(acc.getAccX());
        printf(" X ");
        printf("%f",acc.getAccX());                     //gives x coordinate of accelerometer
        //gled = 1.0 - abs(acc.getAccY());
        printf(" Y ");
        printf("%f",acc.getAccY());                     //gives y coordinate of accelerometer
        //bled = 1.0 - abs(acc.getAccZ());
        printf(" Z ");
        printf("%f\r",acc.getAccZ());                   //gives z coordinate of accelerometer
        
        if  (acc.getAccZ()<-0.3){                       //prints dont slouch + lights led when z axis less than -0.3
            printf("Don't Slouch");    
            led=1;    
        } 
        else led=0;
        
        if  (acc.getAccZ()>0.0){                          //prints sit back = lights led when z axis more than 0 
            printf("Sit Back");  
            led=1;
        }    
        
        wait(0.1);
    }
}
