#include "mbed.h"
#include "C12832.h"

DigitalOut myled[]={LED1,LED2,LED3,LED4};
C12832 lcd(p5, p7, p6, p8, p11);
Serial pc(USBTX, USBRX);
AnalogIn    pot1(p19);
AnalogIn    pot2(p20);

void knight_rider(void const *args) {
    while(1) {
        for(int i=0;i<4;i++) {
            myled[i]=1;
            Thread::wait(100);
            myled[i]=0;
        }
        for(int i=2;i>0;i--) {
            myled[i]=1;
            Thread::wait(100);
            myled[i]=0;
        }
    }
}


void ADC_PC(void const *args) {
    pc.printf("Voltage Measurement\n");
    while(1) {   
        pc.printf("Voltage : %3.3f V \n",pot1.read()*3.3);
        Thread::wait(1000);  //delay 1s
    }
}

void ADC_LCD(void const *args){
    int j=0;            
    lcd.cls();          
    lcd.locate(0,0);    
    lcd.printf("Voltage Measurement");
    while(1) {  
        lcd.locate(0,10);
        lcd.printf("Voltage : %3.3f V",pot2.read()*3.3);
        j++;
        Thread::wait(1000);    
    }
}

int main() {
    Thread thread1(knight_rider, NULL, osPriorityAboveNormal, DEFAULT_STACK_SIZE);
    Thread thread2(ADC_PC, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    Thread thread3(ADC_LCD, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    //OR FOR DEFAULT SETTING CAN USE BELOW STYLE 
    //Thread thread1(knight_rider);
    //Thread thread2(ADC_PC);
    //Thread thread3(ADC_LCD);
    while (1);
}
