#include "mbed.h"
#include "rtos.h"
#include "C12832.h"
 
DigitalOut myled[]={LED1,LED2,LED3,LED4};
AnalogIn pot(p20);
C12832 lcd(p5, p7, p6, p8, p11);
Serial pc(USBTX, USBRX); // tx, rx
PwmOut Speaker(p26);

int frequency[ ] = {440,0,440,0,440,0,349,0,523,0,440,0,349,0,523,0,440,0,
                                                659,0,659,0,659,0,698,0,523,0,784,0,698,0,523,0,440,0};

float beat[ ] = {1,0.4,1,0.4,1,0.4,0.8,0.1,0.4,0.1,1.2,0.2,0.8,0.1,0.4,0.1,1.2,1.6,
                                     1,0.4,1,0.4,1,0.4,0.8,0.1,0.4,0.1,1.2,0.2,0.8,0.1,0.4,0.1,1.2,0.8};
                                     
                                     
typedef struct {
    uint32_t raw_data;  // ADC raw data     
    float    voltage;   // AD result of measured voltage 
} message_t;
 
MemoryPool<message_t, 16> mpool;
Queue<message_t, 16> queue;

void Knight_Rider(void const *args) {
    while(true){
        for(int i=0;i<4;i++) {
            myled[i]=1;
            Thread::wait(100);
            myled[i]=0;
        }
        for(int i=2;i>0;i--) {
            myled[i]=1;
            Thread::wait(100);
            myled[i]=0;
        }
    }
}

void ADC_Update(void const *args) {
    pc.printf("\n\r|*----------------------------*|\n\r");
    pc.printf("|* Example ADC with Interrupt. |\n\r");
    pc.printf("|*----------------------------*|\n\r\n\r");
    while(1) {  
        //osSignalWait(0x01,osWaitForever);
        message_t *message = mpool.alloc();
        message->raw_data = pot.read_u16();
        message->voltage = pot*3.3; 
        queue.put(message);  // Place a value in the message queue
        pc.printf("ADC Value is: %d \n\r\n\r", message->raw_data);// Display ADC value on UART
        Thread::wait(1000);
    }
}


void LCD_Display(void const *args) {
    while (true) {
        osEvent evt = queue.get();
        if (evt.status == osEventMessage) {
            message_t *message = (message_t*)evt.value.p;
            lcd.locate(0,11);
            lcd.printf("Raw Data: %u"   , message->raw_data); 
            lcd.locate(0,20);
            lcd.printf("Voltage: %.2f volt"   , message->voltage);           
            mpool.free(message);
        }
        Thread::wait(1000);
    }
}

void Music(void const *args) {
    while(1) {     
  
        for (uint8_t i=0; i<=35; i++) {
            Speaker.period(1.0/frequency[i]);  // 4 second period
            Speaker=0.5; 
            Thread::wait(400*beat[i]);   // hold for beat period
        }
    
    /*     
        for (float i=2000.0; i<10000.0; i+=100) {
            Speaker.period(1.0/i);
            Speaker=0.5;
            Thread::wait(100);
        }
    */
    }
}
    
int main() {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("mBed-RTOS Mini Project");
    
    //Thread thread1(Knight_Rider, (void *)"Th 1"), osPriorityNormal, (uint32_t) DEFAULT_STACK_SIZE, (unsigned char *)NULL);
    Thread thread1(Knight_Rider);
    Thread thread2(ADC_Update,(void *)"Th 2", osPriorityAboveNormal,DEFAULT_STACK_SIZE,NULL);
    Thread thread3(LCD_Display);
    Thread thread4(Music);
    
    while (true);
}
