#include "mbed.h"

DigitalIn  btn(P14);  // für den Test ist nur dieser erforderlich


BusOut BoardLeds ( LED1 , LED2, LED3, LED4);

Ticker tickerflipper;             // Ticker für blinken der LED
volatile int blinkCounter=0;  // Volatile, damit es nicht auf unterschiedlichen Cores ausgeführt wird

enum State {ST_LEDAUS=0, ST_LEDEIN};
State state;

bool pressed = false;

void flipper()                 // 
{
    blinkCounter++;           // Variable die hochgezählt wird um die LED 2 mal blinken zu lassen
    Led4 = !Led4;           // umschalten der LED
}

 
void rise(void)
{  
    wait_ms(100);           // Entprellung der Taste, bei mir 100ms da der Taster furchtbar prellt...
    pressed = true;         // Umschalten auf WAHR, es wurde gedrückt
}

bool CheckFlag() 
{
    if (pressed)            // Abfrage ob pressed WAHR ist
    {
        pressed=false;      // Rücksetzen wieder auf Status FALSCH
        return true;        // Rückgabe bei CheckFlag das WAHR ist
    }
    return false;           // Wenn nicht pressed Wahr ist wird CheckFlag als FALSCH zurück gegeben
}


void ST_LedAus (void)
{


    
    printf("State: 1 (Aus)");       // Ausgabe auf der seriellen Console
    


    while(true) 
    {
        Led1 = 0;           // Led1 wird auf LOW gesetzt
        if(CheckFlag())     // Ist CheckFlag WAHR dann
        {
            state = ST_LEDEIN; // Wechsel auf Status EIN
            

            return;
            }
        }
}


void ST_LedEin (void)
{

    printf("State: 2 (Ein)");       // Ausgabe auf der seriellen Console
    
    
//____________aufruf um die Led blinken zu lassen____\\
    tickerflipper.attach(&flipper, 0.3);     // the address of the function to be attached (flip) and the interval (0,3 seconds)
    
    while(true)                     // Dauerschleife
    {
        if ( blinkCounter >= 4) break;// Ausbruch aus der Whileschleife wenn der blinkCounter größer gleich 4 ist
    }
        tickerflipper.detach();           // Tiker deaktivieren
        blinkCounter=0;               // blinkCounter rücksetzen auf 0 damit es wieder von vorne losgehen kann
    
    


    while(true) {
        Led1 = 1;
    
        if(CheckFlag()) 
        {
            state = ST_LEDAUS;
            


            return;
            }
        }
}

void ST_Error (void)
{
    printf("State: ERROR!!!");
    return;
}


void stateMachine()
{
    switch (state)
    {
    case ST_LEDAUS: ST_LedAus();
        break;
    case ST_LEDEIN: ST_LedEin();
        break;
    default: ST_Error();  // sollte nicht auftreten :-)
        break;
    }
}


 
int main()
{
    SW1.rise(&rise);      //.fall(&fall);
    state = ST_LEDAUS;
    while(true)
    {
        stateMachine(); 
    }
}