#include "mbed.h"
#include "C12832.h"
#include "LM75B.h"

//      LCD
C12832 lcd(p5, p7, p6, p8, p11);    // Definition der Pins vom LCD
//      Temperatur
LM75B temp (p27, p28);
//      Led
DigitalOut Led1(LED1);   // 1. LED
DigitalOut Led2(LED2);   // 2. LED
DigitalOut Led3(LED3);   // 3. LED
DigitalOut Led4(LED4);   // 4. LED
//      Joystick
InterruptIn  Sw4(p13);      // LEFT
InterruptIn  Sw1(p14);      // CENTER
InterruptIn  Sw2(p15);      // UP
InterruptIn  Sw3(p12);      // DOWN
InterruptIn  Sw5(p16);      // RIGHT


//      Prototyping
void StateMachine();
//void ST_Error (void);
void ST_Ein (void);
void ST_Aus (void);
//void rise(void);
void Sw1Rise(void);
void Sw2Rise(void);
//bool CheckFlag() ;
bool CheckSw1(void);
bool CheckSw2(void);
void Time (void);
void TimeOut(void); 
void Flip (void);
void TempOut (void);
void TimeOutError(void);
void ErrorBlinken(void);
void TimeOver(void);


//bool pressed = false;
bool volatile Sw1Pressed;
bool volatile Sw2Pressed;

//***** VARIABLEN ******

enum State {ST_AUS=0, ST_EIN, ST_TimeOut, ST_TempOut, ST_Error};
//State state;
State volatile state;
Timer getTime; //Timer-Schnittstelle dient zum Erstellen, Starten, Stoppen und Lesen eines Timers 
Ticker TickFlip;//für blinken der LED     //wiederkehrenden Interrupt 
Timeout resetTime;//Die Timeout-Schnittstelle wird verwendet, um einen Interrupt 
                    //einzurichten, um eine Funktion nach einer bestimmten Verzögerung aufzurufen.

volatile int counter; // Volatile, damit es nicht auf unterschiedlichen Cores ausgeführt wird



int main()
{
    
    Sw1.rise(&Sw1Rise);      //.fall(&fall)
    Sw2.rise(&Sw2Rise);//warten auf drücken
    state = ST_AUS;
    Sw1Pressed = 0;
    Sw2Pressed = 0;
    Led1 = 0;
    Led2 = 0;
    Led3 = 0;
    Led4 = 0;
    counter=0;

    while(1)
    {
        
        StateMachine();
    }
}

void TimeOver(void)
{
        lcd.cls();      // löscht lcd (clear screen)
        lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
        lcd.printf("Die Zeit ist abgelaufen");
        printf("Die Zeit ist abgelaufen \n");
        while(1)
    {}
}

void ErrorBlinken(void) ///blineken bei allen fehlern
{
    Led4 = !Led4;
    }

void TimeOutError (void) {///unerwartter fehler
        state = ST_Error;
        TickFlip.attach(&ErrorBlinken, 0.3);
        lcd.cls();      // löscht lcd (clear screen)
        lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
        lcd.printf("State: ERROR TimeOut");
        printf("State: ERROR TimeOut \n");
        
        printf("State: %i \n",state);
        lcd.cls();              // löscht lcd (clear screen)
        lcd.locate(0,0);        // x-position, y-position (x: 0-128; y: 0-32)
        lcd.printf("State: %i", state);   //Ausgabe am Display
    }

void TempOut(void) {//temp ausgabe
        lcd.cls();      // löscht lcd (clear screen)
        lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
        lcd.printf("Temp Out");
        printf ("Temp Out \n");
        int counterTempOut = 0;
        while(1) {
            lcd.cls();      // löscht lcd (clear screen)
            lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
            lcd.printf("Temp Out");
            printf ("Temp Out %f \n", temp.read());
            counterTempOut++;
            wait(1);

            if(CheckSw2() == true) {
                state = ST_EIN;
                return;
            }
        }
    }

void TimeOut(void) {
        lcd.cls();      // löscht lcd (clear screen)
        lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
        lcd.printf("Time Out");
        printf ("TimeOut \n");
        int counter2 = 0;
        while(1) {
            lcd.cls();      // löscht lcd (clear screen)
            lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
            lcd.printf("TimeOut %i", counter2);
            printf ("TimeOut %i \n", counter2);
            counter2++;
            wait(1);
            if(CheckSw2() == true) {
                state = ST_TempOut;
                return;
            }
        }
    }

void Sw2Rise(void) {
        lcd.cls();      // löscht lcd (clear screen)
        lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
        lcd.printf("Sw2Rise");
        printf ("Sw2Rise \n");
        if(state == ST_EIN || state == ST_TimeOut || state == ST_TempOut)      
        Sw2Pressed = true;
        // je weleer status schalte weiter
        wait(0.2);
    }

bool CheckSw2(void) {//Werte true oder false 
        if(Sw2Pressed == true) {
            lcd.cls();      // löscht lcd (clear screen)
            lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
            lcd.printf("CheckSw2");
            printf ("CheckSw2 \n");
            Sw2Pressed = false;
            return true;
        }

        return false;
    }
 
void Time(void) {
        lcd.cls();      // löscht lcd (clear screen)
        lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
        lcd.printf("Time");
        printf ("Time \n");
        if(getTime.read() == 0) 
        {
            getTime.start(); //Timer Starten
        } 
        else {
            lcd.cls();      // löscht lcd (clear screen)
            lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
            lcd.printf("Sekunden: %f", getTime.read());
            printf("Sekunden: %f \n", getTime.read());
            getTime.reset();//Timer löschen
        }
    }      

bool CheckSw1(void) {  ////Werte true oder false 
        if(Sw1Pressed == true) {
            lcd.cls();      // löscht lcd (clear screen)
            lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
            lcd.printf("CheckSw1");
            printf ("CheckSw1 \n");
            Time();  //TIME UNTERPROGRAM
            Sw1Pressed = false;
            return true;
        }

        return false;
    }
    
void Sw1Rise(void) {
        lcd.cls();      // löscht lcd (clear screen)
        lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
        lcd.printf("Sw1Rise");
        printf ("Sw1Rise \n");
        if(state == ST_EIN || state == ST_AUS) {
            // wenn Taste getrückt wird wechsel je welcher status
            Sw1Pressed = true;// Umschalten auf WAHR, es wurde gedrückt
            wait_ms(200);
        }// Entprellung der Taste, bei mir 100ms da der Taster furchtbar prellt...
    } 
 
void Ein (void)
{
    //Status auf LCD und Serial
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 2 (Ein)");
    printf("State: 2 (Ein)");

//  entry

    // aufruf um die Led blinken zu lassen
    TickFlip.attach(&Flip, 0.5);// the address of the function to be attached (Flip) and the interval (2 seconds)
    resetTime.attach(&TimeOutError, 10);//time out starten
    Led1 = true; //led ein

    while(1) {

        if(state == ST_Error) {
            lcd.cls();      // löscht lcd (clear screen)
            lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
            lcd.printf("State: 2 (Ein)verlassen");
            printf("State: 2 (Ein) verlassen");
            Led1 = false;
//          exit
            return;
        }

        
        if(CheckSw2() == true) {
            state = ST_TimeOut;  // state timeOut
            resetTime.detach(); // timeout rücksetzen
//          exit
            return;
        }
        if(CheckSw1() == true) {
            state = ST_AUS;// state aus
            Led1 = false;
            resetTime.detach();// timeout rücksetzen
//          exit
            return;
        }
    }
}

void Flip (void)  //MIT TICKER 2X blinken
{
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("Flip");
    printf ("Flip \n");
    
    Led4 = !Led4;// umschalten der LED
    
    if (counter == 3) {
        TickFlip.detach();//ticker stopp
        counter = 0;
    } 
    else 
        counter++;// Variable die hochgezählt wird um die LED 2 mal blinken zu lassen
    }

void Aus (void)//10s timerout starten
{
    resetTime.attach(&TimeOutError, 10);
    lcd.cls();              // löscht lcd (clear screen)
    lcd.locate(0,0);        // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 1 (Aus)");   //Ausgabe am Display
    printf("State: 1 (Aus)\n");       // Ausgabe auf der seriellen Console

    while(true) {
        if(state == ST_Error) {
            printf("ERROR State AUS verlassen /n");
            lcd.cls();              // löscht lcd (clear screen)
            lcd.locate(0,0);        // x-position, y-position (x: 0-128; y: 0-32)
            lcd.printf("ERROR State AUS verlassen");   //Ausgabe am Display
            return;
        }

        if(CheckSw1() == true) {  //wenn sw1 gedrückt
            state = ST_EIN;
            resetTime.detach(); // timerout wieder stoppen
            return;
        }

    }
}               
void StateMachine()  //mit den ganzen möglichen Statuse
{
    switch (state) 
    {
        case ST_AUS:          Aus()      ;break;
        case ST_EIN:          Ein()      ;break;
        case ST_TimeOut:      TimeOut()     ;break;
        case ST_TempOut:      TempOut()     ;break;
        case ST_Error:        TimeOver()    ;break;
        default: printf("ERROR")            ; 
                 lcd.cls()                  ;               // löscht lcd (clear screen)
                 lcd.locate(0,0)            ;               // x-position, y-position (x: 0-128; y: 0-32)
                 lcd.printf("ERROR")        ;break;         //Ausgabe am Display                     
    }
}








    

    

    

    
    

    

    

    


    



