#include "mbed.h"
 
class SwEventInh: public InterruptIn {
       // InterruptIn _isr;
        volatile bool _pressed;
        void _risingISR();
 
    public:
        SwEventInh(PinName pin) : InterruptIn (pin) {          // create the InterruptIn on the pin specified to SwEvent
            rise(callback(this, &SwEventInh::_risingISR));  // attach ISR-function of this SwEvent instance 
            _pressed=0; 
        }
        int checkFlag();                            // must in do-condition (while(true)-loop) continuously interrogated
};
// ---------------- Switch Event Class Methodes --------------------------
int SwEventInh::checkFlag() {
    if( _pressed ) {
        _pressed = 0; 
        return 1;
    }
    return 0;
}
 
void SwEventInh::_risingISR() {            
    if( read() )
        _pressed = 1;
        _pressed = !_pressed;
}

SwEventInh sw1(p14);
DigitalOut myled(LED1);
 
int main() {
    myled = 1;
    wait(1);
    myled = 0;
    printf("Hello SwEvent v0.1\n");
    while(1) {
        sw1.read();
        if(sw1.checkFlag())
            myled = ! myled; 
    }
}
 