#include "mbed.h"
 
 
 class SerialEvent
 {
    private:
     Serial _isr;                       // für serielles einlesen
     volatile int16_t _pressed;    // wegen multicore unterstützung
     void _risingISR();             // prototyping
     char _str;                      // str ist nur eine Variable, könnte auch zeichen heißen
     
    public:
     int checkFlag();
     void read(char& zeichen);
     SerialEvent(PinName tx, PinName rx): _isr(tx,rx)       //Konstruktor
     {
         _isr.attach(callback(this, &SerialEvent::_risingISR));
     }
    };
      
     void SerialEvent :: read(char& zeichen)
     {
         zeichen= _str;
     }
        
     
     void SerialEvent :: _risingISR()
     {
         _str = _isr.getc();
         _pressed=1;
     }
     
     int SerialEvent :: checkFlag ()
     {
         if(_pressed)
         {
         _pressed=0;
         return true;
         }
         else
         return false;
     }
         
         SerialEvent pc(USBTX, USBRX);  //pc ist wieder nur irgendeine Variable
  
  
  
  
  main()
  {
     
     char z;
     if( pc.checkFlag())
     pc.read(z);
     printf("Zeichen: %c",z);
     
     }