/*#include "mbed.h"

BusOut Leds(LED1, LED2, LED3, LED4);
//BusOut zweiLeds(LED1, LED2);
 
//DigitalOut led1(LED1);
//DigitalOut led2(LED2);
//DigitalOut led3(LED3);
//DigitalOut led4(LED4);
//DigitalIn  btn(P14); 
Ticker tickerflipper;
volatile int cout = 0;
void timeOut(void);  

enum Status {ST_LEDOFF=0, ST_LEDEIN=1,ST_Error};
Stm volatile stm;

class IsA : BusOut{
    
    IsA():BusOut(LED1, LED2, LED3, LED4){};
    
    void LedOFF(){write(0x00);}
    
    void LedON(int lVal){write(lVal)};
    void LedON(){write(0x03);}
    
    };

class IsAnEvent : public InterruptIn {
        volatile int16_t _pressed;
        void _RisingISR(); 
    public:
        IsAnEvent() : InterruptIn(p15) {};
        IsAnEvent(PinName pin) : InterruptIn(pin) {
             rise(callback(this, &IsAnEvent::_RisingISR)); 
            _pressed=0; 
        };
        int CheckFlag();
        void InitIsr();
};

void IsAnEvent::InitIsr() { 
    rise(callback(this, &IsAnEvent::_RisingISR)); 
}

void IsAnEvent::_RisingISR() {
    wait_ms(100);
    if( read() )
        _pressed = true;
    
}

 
IsAnEvent sw1(p14);    // Joy Stick Center
 
int IsAnEvent::CheckFlag() {
    if( _pressed ) { 
        _pressed = false; 
        return 1; 
    }
    return 0;
}

 
void stateMachine()
{
    printf("state: %d\n", stm.state);  
    switch (stm.state)
    {
    case ST_LEDEIN: stm.LedEin();
        break;
    case ST_LEDOFF: stm.LedAus();
        break;
    default: stm.Error();
        break;
    }
}
IsAnEvent sw1(p14);    // Joy Stick Center
 
class Stm {
  public:
        Stm() { state=ST_LEDAUS; }
        
        void Ein();
        void Aus();
        void Error();
 
        uint8_t state;
};

void Stm::Ein()
{
    LedON(){write(0xff)};
    wait(0,1);
    LedOFF(){write(0x00)};
    while(true) {
        LedON.IsA;cout < 3()) {
            state = ST_LEDAUS;
            return;
        }
    }
}
 
void Stm::LedAus(){
    while(true) {
        LedOFF.IsA();
        if(sw1.CheckFlag()) {
            
            return;
        }
    }
}

{
    printf("State: LedAUS");       
    while(true) {
        Leds = 0;
        if(CheckFlag()) 
        {
            state = ST_LEDEIN;
        return;
            }
        }
}
void ST_Error (void)
{
    printf("State: ERROR!!!");
    return;
}
 
void Stm::Error(){
    while(1) {
        led3 = ~led3;
        wait_ms(200);
    }
}
 
 
 
 
int main()
{
 
    while(1) {
        stateMachine(); 
    }
}

void timeOut(void)
{
   

    if(counter >= 3)
    {
        tickerflipper.detach(); //ticker stop
        counter = 0;
        return;
    }
    else counter++;
    return;
}
*/

#include "mbed.h"

DigitalIn  btn(P14);  // Taste


BusOut BoardLeds ( LED1 , LED2, LED3, LED4);

Ticker tickflip;             // Led Ticker
volatile int blinkerCounter=0;  // Volatile, unterschiedlichen Cores 

enum State {ST_LEDAUS=0, ST_LEDEIN};
State state;

bool pressed = false;

void flipper()                 // 
{
    blinkerCounter++;           // Variable um led zum binken
    Led4 = !Led4;           // umschalten 
}

 
void rise(void)
{  
    wait_ms(200);           // Entprellung 
    pressed = true;         //ob gedrückt
}

bool CheckFlag() 
{
    if (pressed)            // ob pressed WAHR ist
    {
        pressed=false;      // Rücksetzen 
        return true;        // Rückgabe 
    }
    return false;           
}


void ST_LedAus (void)
{
    while(true) 
    {
        Led1 = 0;           // Led1 
        if(CheckFlag())     
        {
            state = ST_LEDEIN; 
                      return;
            }
        }
}


void ST_LedEin (void)
{

    tickflip.attach(&flipper, 0.3);     // the address of the function to be attached (flip) and the interval (0,3 seconds)
    
    while(true)                     // Dauerschleife
    {
        if ( blinkCounter == 4) break;// wenn couter 4 ist
    }
        tickflip.detach();           // deaktivieren
        blinkCounter=0;               // blinkCounter rücksetzen auf 0 damit es wieder von vorne losgehen kann
    
    


    while(true) {
        Led1 = 1;
    
        if(CheckFlag()) 
        {
            state = ST_LEDAUS;
            
            return;
            }
        }
}

void ST_Error (void)
{
  Led1 = !Led1; 
    return;
}


void stateMachine()
{
    switch (state)
    {
    case ST_LEDAUS: ST_LedAus();
        break;
    case ST_LEDEIN: ST_LedEin();
        break;
    default: ST_Error();  // sollte nicht auftreten :-)
        break;
    }
}


 
int main()
{
    SW1.rise(&rise);      //.fall(&fall);
    state = ST_LEDAUS;
    while(true)
    {
        stateMachine(); 
    }
}